<?php
// Verificación de la corrección del modal de citas
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['user_name'] = 'Usuario de Prueba';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>✅ Verificación de Corrección - Modal de Cita</title>
    <link rel="stylesheet" href="public/style.css">
    <style>
        body { 
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
            padding: 40px; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            min-height: 100vh; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
        }
        .verification-card { 
            background: white; 
            padding: 40px; 
            border-radius: 16px; 
            box-shadow: 0 20px 40px rgba(0,0,0,0.1); 
            text-align: center; 
            max-width: 600px; 
            width: 100%; 
        }
        .success-icon { 
            font-size: 64px; 
            color: #28a745; 
            margin-bottom: 20px; 
        }
        .error-icon { 
            font-size: 64px; 
            color: #dc3545; 
            margin-bottom: 20px; 
        }
        .test-button { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            color: white; 
            border: none; 
            padding: 15px 30px; 
            border-radius: 8px; 
            cursor: pointer; 
            font-size: 18px; 
            margin: 10px; 
            transition: transform 0.2s; 
        }
        .test-button:hover { 
            transform: translateY(-2px); 
        }
        .status-message { 
            margin: 20px 0; 
            padding: 15px; 
            border-radius: 8px; 
            font-weight: 500; 
        }
        .status-success { 
            background: #d4edda; 
            color: #155724; 
            border: 1px solid #c3e6cb; 
        }
        .status-error { 
            background: #f8d7da; 
            color: #721c24; 
            border: 1px solid #f5c6cb; 
        }
        .code-block { 
            background: #f8f9fa; 
            border: 1px solid #e9ecef; 
            border-radius: 8px; 
            padding: 15px; 
            margin: 20px 0; 
            text-align: left; 
            font-family: 'Courier New', monospace; 
            font-size: 14px; 
            overflow-x: auto; 
        }
    </style>
</head>
<body>
    <div class="verification-card">
        <div id="status-icon" class="success-icon">🔄</div>
        <h1>Verificación de Corrección</h1>
        <h2>Modal de Citas - ProfixCRM</h2>
        
        <div id="status-message" class="status-message">
            Verificando la disponibilidad del modal...
        </div>
        
        <div class="code-block">
            <strong>Función verificada:</strong> ProfixCRM.openAppointmentAssistant()<br>
            <strong>Contexto:</strong> Lead #123 - Juan Pérez<br>
            <strong>Estado:</strong> <span id="verification-status">Verificando...</span>
        </div>
        
        <div style="margin-top: 30px;">
            <button class="test-button" onclick="verifyModal()">
                🔍 Verificar Modal
            </button>
            <button class="test-button" onclick="testModal()">
                🗓️ Probar Modal
            </button>
            <button class="test-button" onclick="showDetails()">
                📋 Ver Detalles
            </button>
        </div>
        
        <div id="debug-info" class="code-block" style="display: none; text-align: left;">
            <strong>Información de Debug:</strong>
            <div id="debug-content"></div>
        </div>
    </div>

    <script src="public/script.js"></script>
    
    <script>
        function updateStatus(isSuccess, message) {
            const icon = document.getElementById('status-icon');
            const statusMessage = document.getElementById('status-message');
            const verificationStatus = document.getElementById('verification-status');
            
            if (isSuccess) {
                icon.textContent = '✅';
                icon.className = 'success-icon';
                statusMessage.className = 'status-message status-success';
                verificationStatus.textContent = 'FUNCIONAL';
            } else {
                icon.textContent = '❌';
                icon.className = 'error-icon';
                statusMessage.className = 'status-message status-error';
                verificationStatus.textContent = 'NO FUNCIONAL';
            }
            
            statusMessage.textContent = message;
        }
        
        function verifyModal() {
            try {
                let status = '';
                let isSuccess = false;
                
                if (window.ProfixCRM) {
                    if (typeof window.ProfixCRM.openAppointmentAssistant === 'function') {
                        status = '✅ El modal de citas está correctamente disponible en ProfixCRM.openAppointmentAssistant';
                        isSuccess = true;
                    } else {
                        status = '❌ ProfixCRM existe pero openAppointmentAssistant no es una función válida';
                    }
                } else {
                    status = '❌ ProfixCRM no está definido en window';
                }
                
                updateStatus(isSuccess, status);
                logDebug('Verificación completada: ' + status);
            } catch (error) {
                updateStatus(false, '❌ Error durante la verificación: ' + error.message);
                logDebug('Error: ' + error.message);
            }
        }
        
        function testModal() {
            try {
                if (window.ProfixCRM && typeof window.ProfixCRM.openAppointmentAssistant === 'function') {
                    window.ProfixCRM.openAppointmentAssistant({
                        clientName: 'Juan Pérez',
                        leadId: 123
                    });
                    updateStatus(true, '✅ Modal abierto exitosamente para Juan Pérez (Lead #123)');
                    logDebug('Modal abierto con éxito para el lead de prueba');
                } else {
                    updateStatus(false, '❌ No se puede abrir el modal - función no disponible');
                    logDebug('La función openAppointmentAssistant no está disponible');
                }
            } catch (error) {
                updateStatus(false, '❌ Error al abrir el modal: ' + error.message);
                logDebug('Error al abrir modal: ' + error.message);
            }
        }
        
        function showDetails() {
            const debugInfo = document.getElementById('debug-info');
            const debugContent = document.getElementById('debug-content');
            
            let details = '<strong>Estado del Sistema:</strong><br>';
            details += 'window existe: ' + (typeof window !== 'undefined') + '<br>';
            details += 'window.ProfixCRM existe: ' + (typeof window.ProfixCRM !== 'undefined') + '<br>';
            
            if (window.ProfixCRM) {
                details += 'Funciones en ProfixCRM: ' + Object.keys(window.ProfixCRM).join(', ') + '<br>';
                details += 'openAppointmentAssistant es función: ' + (typeof window.ProfixCRM.openAppointmentAssistant === 'function') + '<br>';
            }
            
            details += '<br><strong>Corrección aplicada:</strong><br>';
            details += 'Se agregó verificación de existencia antes de Object.assign()<br>';
            details += 'Línea 514-517 en script.js: if (!window.ProfixCRM) { window.ProfixCRM = {}; }<br>';
            
            debugContent.innerHTML = details;
            debugInfo.style.display = debugInfo.style.display === 'none' ? 'block' : 'none';
        }
        
        function logDebug(message) {
            console.log('[Verificación Modal] ' + message);
        }
        
        // Verificación automática al cargar
        window.addEventListener('load', function() {
            setTimeout(verifyModal, 1000);
        });
    </script>
</body>
</html>