<?php
if (!defined('BASE_PATH')) { define('BASE_PATH', __DIR__ . '/..'); }
require_once BASE_PATH . '/database/connection.php';
require_once BASE_PATH . '/api/shared/ApiLoader.php';
header('Content-Type: application/json');
try {
    $pdo = Database::getInstance()->getConnection();
    $client = ApiLoader::getIntegrationClient('key2pay', $pdo);
    $res = $client->getPaymentMethods([ 'currency' => 'USD' ]);
    $listCount = 0; $first = null;
    if (!empty($res['json']) && is_array($res['json'])) {
        if (isset($res['json']['items']) && is_array($res['json']['items'])) {
            $listCount = count($res['json']['items']);
            $first = $res['json']['items'][0] ?? null;
        } else if (isset($res['json'][0])) {
            $listCount = count($res['json']);
            $first = $res['json'][0];
        }
    }
    echo json_encode([
        'success' => (bool)($res['success'] ?? false),
        'status' => $res['http_code'] ?? null,
        'count' => $listCount,
        'first' => $first
    ]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}

