<?php
if (!defined('BASE_PATH')) { define('BASE_PATH', __DIR__ . '/..'); }
require_once BASE_PATH . '/database/connection.php';
require_once BASE_PATH . '/api/shared/ApiLoader.php';
header('Content-Type: application/json');
try {
    $pdo = Database::getInstance()->getConnection();
    $client = ApiLoader::getIntegrationClient('key2pay', $pdo);
    $res = $client->createCheckoutPage([
        'currency' => 'USD',
        'amount' => 1550,
        'language' => 'ES',
        'description' => 'Depósito de prueba',
        'notificationUrl' => 'https://goldendragonexchange.com/api/key2pay/ipn',
        'returnUrl' => 'https://goldendragonexchange.com/portal/payment_success',
        'cancelUrl' => 'https://goldendragonexchange.com/portal/payment_cancel',
        'customer' => [ 'FirstName'=>'Carlos','LastName'=>'Mendoza','Email'=>'cliente.demo@example.com', 'Mobile'=>'+34666777888' ]
    ]);
    $out = [ 'success'=>$res['success'] ?? false, 'status'=>$res['http_code'] ?? null, 'checkout_url'=>$res['json']['checkoutUrl'] ?? null, 'body'=> isset($res['body']) && is_string($res['body']) ? substr($res['body'],0,500) : null ];
    echo json_encode($out);
} catch (Throwable $e) { echo json_encode(['success'=>false,'message'=>$e->getMessage()]); }
