<?php
session_start();
require_once 'database/connection.php';

// Simular usuario logueado para la prueba
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1; // Usuario de prueba
    $_SESSION['username'] = 'test_user';
}

echo "<h2>🧪 Prueba del Endpoint update_status.php</h2>\n";
echo "<style>body { font-family: Arial, sans-serif; margin: 20px; } .test-result { padding: 10px; margin: 10px 0; border-radius: 5px; } .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; } .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; } .info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }</style>\n";

// Función para hacer una petición POST simulada
function testStatusUpdate($leadId, $newStatus) {
    // Simular datos POST
    $_POST['lead_id'] = $leadId;
    $_POST['status'] = $newStatus;
    $_SERVER['REQUEST_METHOD'] = 'POST';
    $_SERVER['HTTP_X_REQUESTED_WITH'] = 'XMLHttpRequest';
    
    // Capturar la salida del endpoint
    ob_start();
    
    try {
        include 'modules/leads/update_status.php';
        $output = ob_get_contents();
    } catch (Exception $e) {
        $output = json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    
    ob_end_clean();
    
    // Limpiar variables POST para la siguiente prueba
    unset($_POST['lead_id'], $_POST['status']);
    
    return $output;
}

// Verificar que el lead 10292 existe
echo "<h3>1. Verificación del Lead de Prueba</h3>\n";
try {
    $lead = $db->select("SELECT id, status, desk_id FROM leads WHERE id = ?", [10292]);
    if ($lead) {
        $lead = $lead[0];
        echo "<div class='test-result success'>✅ Lead 10292 encontrado - Status actual: <strong>{$lead['status']}</strong></div>\n";
        
        // Prueba 1: Cambiar a un status válido
        echo "<h3>2. Prueba 1: Cambiar Status a 'contacted'</h3>\n";
        $result1 = testStatusUpdate(10292, 'contacted');
        echo "<div class='test-result info'><strong>Respuesta del servidor:</strong><br><pre>" . htmlspecialchars($result1) . "</pre></div>\n";
        
        $decoded1 = json_decode($result1, true);
        if ($decoded1 && isset($decoded1['success'])) {
            if ($decoded1['success']) {
                echo "<div class='test-result success'>✅ Prueba 1 exitosa: Status cambiado correctamente</div>\n";
            } else {
                echo "<div class='test-result error'>❌ Prueba 1 falló: " . ($decoded1['message'] ?? 'Error desconocido') . "</div>\n";
            }
        } else {
            echo "<div class='test-result error'>❌ Prueba 1 falló: Respuesta no es JSON válido</div>\n";
        }
        
        // Prueba 2: Cambiar a un status inválido
        echo "<h3>3. Prueba 2: Cambiar Status a 'invalid_status'</h3>\n";
        $result2 = testStatusUpdate(10292, 'invalid_status');
        echo "<div class='test-result info'><strong>Respuesta del servidor:</strong><br><pre>" . htmlspecialchars($result2) . "</pre></div>\n";
        
        $decoded2 = json_decode($result2, true);
        if ($decoded2 && isset($decoded2['success'])) {
            if (!$decoded2['success']) {
                echo "<div class='test-result success'>✅ Prueba 2 exitosa: Status inválido rechazado correctamente</div>\n";
            } else {
                echo "<div class='test-result error'>❌ Prueba 2 falló: Status inválido fue aceptado</div>\n";
            }
        } else {
            echo "<div class='test-result error'>❌ Prueba 2 falló: Respuesta no es JSON válido</div>\n";
        }
        
        // Prueba 3: Lead inexistente
        echo "<h3>4. Prueba 3: Lead Inexistente</h3>\n";
        $result3 = testStatusUpdate(99999, 'contacted');
        echo "<div class='test-result info'><strong>Respuesta del servidor:</strong><br><pre>" . htmlspecialchars($result3) . "</pre></div>\n";
        
        $decoded3 = json_decode($result3, true);
        if ($decoded3 && isset($decoded3['success'])) {
            if (!$decoded3['success']) {
                echo "<div class='test-result success'>✅ Prueba 3 exitosa: Lead inexistente rechazado correctamente</div>\n";
            } else {
                echo "<div class='test-result error'>❌ Prueba 3 falló: Lead inexistente fue aceptado</div>\n";
            }
        } else {
            echo "<div class='test-result error'>❌ Prueba 3 falló: Respuesta no es JSON válido</div>\n";
        }
        
    } else {
        echo "<div class='test-result error'>❌ Lead 10292 no encontrado</div>\n";
    }
} catch (Exception $e) {
    echo "<div class='test-result error'>❌ Error al verificar lead: " . $e->getMessage() . "</div>\n";
}

// Verificar estructura de la tabla leads
echo "<h3>5. Verificación de la Estructura de la Tabla</h3>\n";
try {
    $columns = $db->select("DESCRIBE leads");
    $statusColumn = null;
    foreach ($columns as $column) {
        if ($column['Field'] === 'status') {
            $statusColumn = $column;
            break;
        }
    }
    
    if ($statusColumn) {
        echo "<div class='test-result success'>✅ Columna 'status' encontrada - Tipo: {$statusColumn['Type']}</div>\n";
    } else {
        echo "<div class='test-result error'>❌ Columna 'status' no encontrada</div>\n";
    }
} catch (Exception $e) {
    echo "<div class='test-result error'>❌ Error al verificar estructura: " . $e->getMessage() . "</div>\n";
}

// Verificar permisos de archivo
echo "<h3>6. Verificación de Archivos</h3>\n";
$files_to_check = [
    'modules/leads/update_status.php',
    'modules/leads/view_scripts.js',
    'modules/leads/view_content.php'
];

foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        if (is_readable($file)) {
            echo "<div class='test-result success'>✅ {$file} - Existe y es legible</div>\n";
        } else {
            echo "<div class='test-result error'>❌ {$file} - Existe pero no es legible</div>\n";
        }
    } else {
        echo "<div class='test-result error'>❌ {$file} - No existe</div>\n";
    }
}

echo "<h3>7. Resumen</h3>\n";
echo "<div class='test-result info'>\n";
echo "<strong>Para probar en producción:</strong><br>\n";
echo "1. Abre la consola del navegador (F12)<br>\n";
echo "2. Ve a la página del lead: <code>view.php?id=10292</code><br>\n";
echo "3. Cambia el status en el dropdown<br>\n";
echo "4. Verifica que aparezca la notificación de éxito<br>\n";
echo "5. Verifica que el status se actualice sin recargar la página<br>\n";
echo "</div>\n";
?>