<?php
// Test de sesión y endpoint AJAX
session_start();

// Simular una sesión activa para pruebas
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1; // Simular usuario logueado
    $_SESSION['username'] = 'test_user';
}

echo "<h1>Debug de Sesión y Endpoint</h1>";
echo "<h3>Estado de la Sesión:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h3>Probar Endpoint AJAX:</h3>";

// Probar el endpoint directamente
$lead_id = 3;
$page = 1;

echo "<p><strong>Probando:</strong> load_activities_ajax.php?lead_id=$lead_id&page=$page</p>";

// Hacer la petición al endpoint
$url = "http://localhost:8000/modules/leads/load_activities_ajax.php?lead_id=$lead_id&page=$page";

// Usar cURL con cookies de sesión
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIE, "PHPSESSID=" . session_id());
curl_setopt($ch, CURLOPT_HEADER, false);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<h3>Respuesta del Endpoint:</h3>";
echo "<p><strong>Código HTTP:</strong> $http_code</p>";
echo "<p><strong>Respuesta:</strong></p>";
echo "<pre>";
echo htmlspecialchars($response);
echo "</pre>";

// Intentar decodificar JSON
$json_data = json_decode($response, true);
if ($json_data) {
    echo "<h3>JSON Decodificado:</h3>";
    echo "<pre>";
    print_r($json_data);
    echo "</pre>";
} else {
    echo "<p><strong>Error:</strong> No se pudo decodificar el JSON</p>";
}

// Probar también con JavaScript
?>
<h3>Prueba con JavaScript:</h3>
<button onclick="testAjax()">Probar AJAX</button>
<div id="result"></div>

<script>
function testAjax() {
    const resultDiv = document.getElementById('result');
    resultDiv.innerHTML = 'Cargando...';
    
    fetch('modules/leads/load_activities_ajax.php?lead_id=3&page=1')
        .then(response => response.json())
        .then(data => {
            resultDiv.innerHTML = '<pre>' + JSON.stringify(data, null, 2) + '</pre>';
        })
        .catch(error => {
            resultDiv.innerHTML = 'Error: ' + error.message;
        });
}
</script>