<?php
/**
 * Archivo de prueba para verificar que PHP funciona correctamente
 */

echo "<h1>Servidor PHP funcionando correctamente</h1>";
echo "<p>Fecha y hora: " . date('Y-m-d H:i:s') . "</p>";
echo "<p>Versión de PHP: " . phpversion() . "</p>";

// Probar conexión a base de datos
try {
    require_once __DIR__ . '/database/config.php';
    require_once __DIR__ . '/database/connection.php';
    
    $db = getDB();
    echo "<p style='color: green;'>✅ Conexión a base de datos exitosa</p>";
    
    // Probar una consulta simple
    $result = $db->select("SELECT COUNT(*) as total FROM users");
    if ($result) {
        echo "<p style='color: green;'>✅ Consulta a base de datos exitosa - Total usuarios: " . $result[0]['total'] . "</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error de base de datos: " . $e->getMessage() . "</p>";
}

echo "<p><a href='index.php'>Ir al sistema principal</a></p>";
echo "<p><a href='modules/auth/login.php'>Ir al login</a></p>";
?>