<?php
/**
 * Test para verificar la respuesta exacta de add_note.php
 * Simula una petición real desde el navegador
 */

// Simular sesión de usuario
session_start();
$_SESSION['user_id'] = 1;

echo "<h2>Test de Respuesta de add_note.php</h2>\n";

// Datos de prueba
$testData = [
    'lead_id' => 3,
    'type' => 'note',
    'subject' => 'Test Respuesta',
    'description' => 'Test para verificar la respuesta JSON',
    'activity_date' => date('Y-m-d H:i:s'),
    'created_by' => 1
];

echo "<h3>Datos enviados:</h3>\n";
echo "<pre>" . json_encode($testData, JSON_PRETTY_PRINT) . "</pre>\n";

// Crear contexto de stream para simular petición HTTP
$context = stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => [
            'Content-Type: application/json',
            'Cookie: ' . session_name() . '=' . session_id()
        ],
        'content' => json_encode($testData)
    ]
]);

echo "<h3>Respuesta cruda del servidor:</h3>\n";

// Obtener la respuesta
try {
    $url = 'http://localhost:8000/modules/leads/add_note.php';
    $response = file_get_contents($url, false, $context);
    
    if ($response === false) {
        echo "<p style='color: red;'>❌ Error al obtener respuesta del servidor</p>\n";
    } else {
        echo "<h4>Contenido crudo:</h4>\n";
        echo "<pre style='background: #f4f4f4; padding: 10px; border: 1px solid #ccc;'>";
        echo htmlspecialchars($response);
        echo "</pre>\n";
        
        echo "<h4>Longitud de la respuesta: " . strlen($response) . " caracteres</h4>\n";
        
        // Intentar parsear como JSON
        echo "<h4>Análisis JSON:</h4>\n";
        $jsonData = json_decode($response, true);
        
        if (json_last_error() === JSON_ERROR_NONE) {
            echo "<p style='color: green;'>✅ La respuesta es JSON válido</p>\n";
            echo "<pre>" . json_encode($jsonData, JSON_PRETTY_PRINT) . "</pre>\n";
        } else {
            echo "<p style='color: red;'>❌ La respuesta NO es JSON válido</p>\n";
            echo "<p>Error de JSON: " . json_last_error_msg() . "</p>\n";
            
            // Buscar caracteres problemáticos
            echo "<h4>Caracteres no imprimibles:</h4>\n";
            for ($i = 0; $i < strlen($response); $i++) {
                $char = $response[$i];
                $ord = ord($char);
                if ($ord < 32 && $ord != 9 && $ord != 10 && $ord != 13) {
                    echo "Posición $i: Carácter $ord (0x" . dechex($ord) . ")\n";
                }
            }
        }
        
        // Verificar headers HTTP
        echo "<h4>Headers HTTP:</h4>\n";
        $headers = get_headers($url, 1);
        echo "<pre>" . print_r($headers, true) . "</pre>\n";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Excepción: " . $e->getMessage() . "</p>\n";
}

echo "<hr>\n";
echo "<h3>Verificando actividades del lead 3:</h3>\n";
echo "<iframe src='debug_activities.php?lead_id=3' width='100%' height='300px' style='border: 1px solid #ccc;'></iframe>\n";

?>