<?php
// Test final de paginación después de las correcciones
session_start();

// Simular sesión activa
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['username'] = 'admin';
    $_SESSION['user_name'] = 'Admin User';
    $_SESSION['login_time'] = time();
}

echo "<h1>Test Final de Paginación - Lead ID 3</h1>";
echo "<h3>Correcciones aplicadas:</h3>";
echo "<ul>";
echo "<li>✅ Eliminada duplicación de error_logger.js</li>";
echo "<li>✅ Agregado credentials: 'same-origin' en peticiones AJAX</li>";
echo "<li>✅ Agregados headers X-Requested-With y Content-Type</li>";
echo "</ul>";

echo "<h3>Estado de Sesión:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";
?>

<h3>Test de Paginación Interactivo:</h3>
<div style="border: 1px solid #ddd; padding: 20px; margin: 20px 0; border-radius: 8px;">
    <h4>Historial de Actividades - Lead ID 3</h4>
    <div id="activityTimeline">
        <div class="loading-activities">Cargando actividades...</div>
    </div>
    <div class="pagination-controls"></div>
</div>

<h3>Controles de Test:</h3>
<button onclick="testPage(1)">Página 1</button>
<button onclick="testPage(2)">Página 2</button>
<button onclick="testPage(3)">Página 3</button>
<button onclick="reloadActivities()">Recargar</button>

<h3>Log de Resultados:</h3>
<div id="testLog" style="background: #f8f9fa; padding: 15px; border-radius: 5px; font-family: monospace; white-space: pre-wrap;"></div>

<script>
// Simular datos del lead
window.leadData = { id: 3 };

// Log function
function log(message) {
    const logDiv = document.getElementById('testLog');
    const timestamp = new Date().toLocaleTimeString();
    logDiv.textContent += `[${timestamp}] ${message}\n`;
    logDiv.scrollTop = logDiv.scrollHeight;
}

// Función de paginación corregida
function loadActivitiesPage(page) {
    const leadId = window.leadData?.id;
    if (!leadId) {
        log('ERROR: No se encontró leadId');
        return;
    }
    
    log(`Cargando página ${page} para lead ${leadId}...`);
    
    // Mostrar indicador de carga
    const timeline = document.getElementById('activityTimeline');
    if (timeline) {
        timeline.innerHTML = '<div class="loading-activities">Cargando actividades...</div>';
    }
    
    fetch(`modules/leads/load_activities_ajax.php?lead_id=${leadId}&page=${page}`, {
        method: 'GET',
        credentials: 'same-origin', // Incluir cookies de sesión
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
        .then(response => {
            log(`Respuesta recibida: ${response.status} ${response.statusText}`);
            return response.json();
        })
        .then(data => {
            log(`Datos recibidos: ${JSON.stringify(data, null, 2)}`);
            
            if (data.success) {
                // Actualizar el contenido del timeline
                if (timeline) {
                    timeline.innerHTML = data.html;
                }
                
                // Actualizar la paginación
                const paginationContainer = document.querySelector('.pagination-controls');
                if (paginationContainer && data.pagination_html) {
                    paginationContainer.innerHTML = data.pagination_html;
                }
                
                log(`✅ Página ${page} cargada exitosamente. Total: ${data.total_activities} actividades`);
            } else {
                log(`❌ Error: ${data.message || 'Error desconocido'}`);
                timeline.innerHTML = `<div style="color: red; padding: 20px;">Error: ${data.message}</div>`;
            }
        })
        .catch(error => {
            log(`❌ Error de red: ${error.message}`);
            console.error('Error:', error);
            timeline.innerHTML = `<div style="color: red; padding: 20px;">Error de conexión: ${error.message}</div>`;
        });
}

// Funciones de test
function testPage(page) {
    log(`\n=== TEST PÁGINA ${page} ===`);
    loadActivitiesPage(page);
}

function reloadActivities() {
    log('\n=== RECARGA COMPLETA ===');
    loadActivitiesPage(1);
}

// Auto-cargar al inicio
window.onload = function() {
    log('=== INICIO DEL TEST ===');
    log('Iniciando carga automática de la página 1...');
    loadActivitiesPage(1);
};

// Estilos básicos
const styles = document.createElement('style');
styles.textContent = `
    .loading-activities {
        text-align: center;
        padding: 40px;
        color: #666;
        font-size: 16px;
    }
    .pagination-controls {
        margin-top: 20px;
        text-align: center;
    }
    .pagination-btn {
        padding: 8px 12px;
        margin: 0 4px;
        border: 1px solid #ddd;
        background: white;
        color: #333;
        border-radius: 6px;
        cursor: pointer;
        font-size: 14px;
    }
    .pagination-btn:hover {
        background-color: #f8f9fa;
        border-color: #007bff;
    }
    .pagination-btn.pagination-active {
        background-color: #007bff;
        color: white;
        border-color: #007bff;
    }
`;
document.head.appendChild(styles);
</script>