<?php
// Script de prueba para verificar la paginación de actividades
session_start();
$_SESSION['user_id'] = 1; // Simular usuario autenticado

require_once __DIR__ . '/database/config.php';
require_once __DIR__ . '/database/connection.php';

$db = getDB();
$lead_id = 1;

// Crear algunas actividades de prueba si no existen
$existing_activities = $db->count("SELECT COUNT(*) FROM lead_activities WHERE lead_id = ?", [$lead_id]);

if ($existing_activities < 10) {
    echo "<h3>Creando actividades de prueba...</h3>";
    for ($i = 1; $i <= 15; $i++) {
        $db->execute(
            "INSERT INTO lead_activities (lead_id, type, description, created_by, created_at) VALUES (?, ?, ?, ?, NOW())",
            [$lead_id, 'note', "Actividad de prueba #$i", 1]
        );
    }
    echo "<p>✅ 15 actividades de prueba creadas</p>";
} else {
    echo "<p>✅ Ya existen $existing_activities actividades</p>";
}

// Probar diferentes páginas
echo "<h3>Probando paginación:</h3>";
for ($page = 1; $page <= 3; $page++) {
    echo "<h4>Página $page:</h4>";
    $offset = ($page - 1) * 5;
    $activities = $db->select(
        "SELECT la.*, u.username AS creator_username 
         FROM lead_activities la
         LEFT JOIN users u ON la.created_by = u.id
         WHERE la.lead_id = ?
         ORDER BY la.created_at DESC
         LIMIT 5 OFFSET ?",
        [$lead_id, $offset]
    );
    
    echo "<ul>";
    foreach ($activities as $activity) {
        echo "<li>" . htmlspecialchars($activity['description']) . " - " . $activity['created_at'] . "</li>";
    }
    echo "</ul>";
}

echo "<hr>";
echo "<h3>Probando endpoint AJAX:</h3>";
echo "<a href='modules/leads/load_activities_ajax.php?lead_id=1&page=1' target='_blank'>Página 1 AJAX</a><br>";
echo "<a href='modules/leads/load_activities_ajax.php?lead_id=1&page=2' target='_blank'>Página 2 AJAX</a><br>";
echo "<a href='modules/leads/load_activities_ajax.php?lead_id=1&page=3' target='_blank'>Página 3 AJAX</a><br>";

echo "<hr>";
echo "<h3>Ver perfil del lead:</h3>";
echo "<a href='modules/leads/view.php?id=1' target='_blank'>Ver Lead #1</a>";

session_destroy(); // Limpiar sesión de prueba