<?php
// Página de prueba para verificar el modal de citas
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Prueba Modal Cita</title>
    <link rel="stylesheet" href="public/style.css">
</head>
<body>
    <div style="padding: 50px; text-align: center;">
        <h1>Prueba Modal de Cita</h1>
        <button onclick="testModal()" style="padding: 15px 30px; font-size: 16px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
            Probar Modal de Cita
        </button>
        
        <div style="margin-top: 30px;">
            <button onclick="testProfixCRM()" style="padding: 10px 20px; margin: 5px; background: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer;">
                Verificar ProfixCRM
            </button>
            
            <button onclick="testDirectModal()" style="padding: 10px 20px; margin: 5px; background: #dc3545; color: white; border: none; border-radius: 5px; cursor: pointer;">
                Modal Directo
            </button>
        </div>
        
        <div id="debug-info" style="margin-top: 30px; padding: 20px; background: #f8f9fa; border-radius: 5px; text-align: left;">
            <h3>Información de Debug:</h3>
            <div id="debug-content"></div>
        </div>
    </div>

    <script src="public/script.js"></script>
    <script>
        function log(message) {
            const debugContent = document.getElementById('debug-content');
            debugContent.innerHTML += '<div>' + new Date().toLocaleTimeString() + ': ' + message + '</div>';
        }
        
        function testProfixCRM() {
            log('=== Verificando ProfixCRM ===');
            log('window.ProfixCRM existe: ' + (typeof window.ProfixCRM !== 'undefined'));
            if (window.ProfixCRM) {
                log('ProfixCRM.openAppointmentAssistant existe: ' + (typeof window.ProfixCRM.openAppointmentAssistant === 'function'));
                log('Funciones disponibles en ProfixCRM: ' + Object.keys(window.ProfixCRM).join(', '));
            } else {
                log('ProfixCRM no está definido');
            }
        }
        
        function testModal() {
            log('=== Intentando abrir modal con ProfixCRM ===');
            try {
                if (window.ProfixCRM && window.ProfixCRM.openAppointmentAssistant) {
                    window.ProfixCRM.openAppointmentAssistant({
                        clientName: 'Cliente de Prueba',
                        leadId: 123
                    });
                    log('Modal abierto exitosamente');
                } else {
                    log('ERROR: ProfixCRM u openAppointmentAssistant no disponible');
                }
            } catch (error) {
                log('ERROR al abrir modal: ' + error.message);
                console.error('Error completo:', error);
            }
        }
        
        function testDirectModal() {
            log('=== Intentando abrir modal directamente ===');
            try {
                if (typeof openAppointmentAssistant === 'function') {
                    openAppointmentAssistant({
                        clientName: 'Cliente de Prueba Directa',
                        leadId: 456
                    });
                    log('Modal directo abierto exitosamente');
                } else {
                    log('ERROR: openAppointmentAssistant no está en el scope global');
                }
            } catch (error) {
                log('ERROR al abrir modal directo: ' + error.message);
                console.error('Error completo:', error);
            }
        }
        
        // Verificaciones iniciales
        window.addEventListener('load', function() {
            log('Página cargada');
            testProfixCRM();
        });
    </script>
</body>
</html>