<?php
/**
 * Debug específico del proceso de login
 */

require_once 'database/connection.php';

// Simular el proceso de login exactamente como lo hace login.php
$username = 'admin';
$password = 'password';

echo "<h2>Debug del proceso de login</h2>";
echo "<p><strong>Probando con:</strong></p>";
echo "<ul>";
echo "<li>Usuario: <code>" . htmlspecialchars($username) . "</code></li>";
echo "<li>Contraseña: <code>" . htmlspecialchars($password) . "</code></li>";
echo "</ul>";

try {
    $db = getDB();
    
    echo "<h3>1. Conexión a base de datos</h3>";
    echo "<p style='color: green;'>✓ Conexión exitosa</p>";
    
    echo "<h3>2. Búsqueda de usuario</h3>";
    $user = $db->selectOne(
        "SELECT id, username, email, password_hash, first_name, last_name, status 
         FROM users 
         WHERE (username = ? OR email = ?) AND status = 'active'",
        [$username, $username]
    );
    
    if ($user) {
        echo "<p style='color: green;'>✓ Usuario encontrado:</p>";
        echo "<ul>";
        echo "<li>ID: " . $user['id'] . "</li>";
        echo "<li>Username: " . htmlspecialchars($user['username']) . "</li>";
        echo "<li>Email: " . htmlspecialchars($user['email']) . "</li>";
        echo "<li>Nombre: " . htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) . "</li>";
        echo "<li>Estado: " . htmlspecialchars($user['status']) . "</li>";
        echo "<li>Hash almacenado: " . htmlspecialchars(substr($user['password_hash'], 0, 20)) . "...</li>";
        echo "</ul>";
        
        echo "<h3>3. Verificación de contraseña</h3>";
        if (password_verify($password, $user['password_hash'])) {
            echo "<p style='color: green;'>✓ Contraseña correcta - LOGIN EXITOSO</p>";
            echo "<p><strong>El usuario debería poder iniciar sesión correctamente.</strong></p>";
        } else {
            echo "<p style='color: red;'>✗ Contraseña incorrecta</p>";
            echo "<p>Hash esperado: " . htmlspecialchars($user['password_hash']) . "</p>";
            
            // Probar generar un nuevo hash
            $new_hash = password_hash($password, PASSWORD_DEFAULT);
            echo "<p>Nuevo hash generado: " . htmlspecialchars($new_hash) . "</p>";
            
            if (password_verify($password, $new_hash)) {
                echo "<p style='color: orange;'>El nuevo hash funciona - problema con el hash almacenado</p>";
            }
        }
    } else {
        echo "<p style='color: red;'>✗ Usuario no encontrado</p>";
        
        // Buscar sin filtro de estado
        echo "<h3>Búsqueda sin filtro de estado:</h3>";
        $user_any = $db->selectOne(
            "SELECT id, username, email, status FROM users WHERE username = ? OR email = ?",
            [$username, $username]
        );
        
        if ($user_any) {
            echo "<p style='color: orange;'>Usuario encontrado pero con estado: " . $user_any['status'] . "</p>";
        } else {
            echo "<p style='color: red;'>Usuario no existe en la base de datos</p>";
        }
    }
    
    echo "<h3>4. Todos los usuarios en la base de datos:</h3>";
    $all_users = $db->select("SELECT username, email, status FROM users");
    if (!empty($all_users)) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Username</th><th>Email</th><th>Estado</th></tr>";
        foreach ($all_users as $u) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($u['username']) . "</td>";
            echo "<td>" . htmlspecialchars($u['email']) . "</td>";
            echo "<td>" . htmlspecialchars($u['status']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>No hay usuarios en la base de datos</p>";
    }
    
} catch (Exception $e) {
    echo "<h3 style='color: red;'>Error:</h3>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>Prueba con otros usuarios:</h3>";
$test_users = ['manager1', 'agent1', 'agent2'];
foreach ($test_users as $test_user) {
    try {
        $user = $db->selectOne(
            "SELECT username, status FROM users WHERE username = ?",
            [$test_user]
        );
        if ($user) {
            echo "<p>✓ <strong>" . $test_user . "</strong>: " . $user['status'] . "</p>";
        } else {
            echo "<p>✗ <strong>" . $test_user . "</strong>: No encontrado</p>";
        }
    } catch (Exception $e) {
        echo "<p>✗ <strong>" . $test_user . "</strong>: Error - " . $e->getMessage() . "</p>";
    }
}
?>