<?php
// Test directo del lead view
session_start();

// Simular sesión
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'test_user';
$_SESSION['role'] = 'admin';

// Definir constantes necesarias
if (!defined('BASE_PATH')) {
    define('BASE_PATH', __DIR__);
}
if (!defined('APP_NAME')) {
    define('APP_NAME', 'ProfixCRM');
}

// Función isLoggedIn
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

echo "<h1>🧪 Test Directo Lead View</h1>";

// Simular parámetros
$_GET['id'] = 10292;
$lead_id = 10292;

echo "<h2>1. Verificando conexión y datos...</h2>";

try {
    require_once 'database/connection.php';
    
    $stmt = $pdo->prepare("SELECT * FROM leads WHERE id = ?");
    $stmt->execute([$lead_id]);
    $lead = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($lead) {
        echo "✅ Lead encontrado: " . $lead['first_name'] . " " . $lead['last_name'] . "<br>";
        
        // Simular las variables que necesita view_content.php
        $page_title = 'Perfil del Lead - ' . htmlspecialchars(trim(($lead['first_name'] ?? '') . ' ' . ($lead['last_name'] ?? '')));
        $module = 'leads';
        $action = 'view';
        
        // Variables adicionales que necesita view_content.php
        $activities = [];
        $stats = [
            'total_calls' => 0,
            'total_emails' => 0,
            'total_meetings' => 0,
            'completed_tasks' => 0,
            'pending_tasks' => 0,
            'last_activity' => null
        ];
        $total_pages = 1;
        $page = 1;
        $canViewEmailFull = true;
        $canViewPhoneFull = true;
        $canClickToCall = true;
        
        echo "<h2>2. Incluyendo view_content.php directamente...</h2>";
        
        // Incluir directamente el contenido
        include 'modules/leads/view_content.php';
        
    } else {
        echo "❌ Lead no encontrado<br>";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    echo "Stack trace: " . $e->getTraceAsString() . "<br>";
}
?>