<?php
/**
 * Test Frontend - Simular petición AJAX para agregar nota
 */

require_once 'database/config.php';
require_once 'database/connection.php';
session_start();

// Simular sesión de usuario
$_SESSION['user_id'] = 1;

header('Content-Type: application/json; charset=utf-8');

try {
    // Datos de prueba para simular lo que enviaría el frontend
    $test_data = [
        'lead_id' => 3,
        'type' => 'call',
        'subject' => 'Test desde Frontend',
        'description' => 'Esta es una prueba de llamada telefónica desde el frontend',
        'activity_date' => date('Y-m-d H:i:s'),
        'created_by' => 1
    ];
    
    // Inicializar cURL para simular la petición AJAX
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://127.0.0.1:8000/modules/leads/add_note.php');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($test_data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Requested-With: XMLHttpRequest'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    
    // Ejecutar la petición
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $body = substr($response, $header_size);
    
    curl_close($ch);
    
    echo json_encode([
        'success' => true,
        'test_type' => 'frontend_ajax',
        'http_code' => $http_code,
        'response' => json_decode($body, true),
        'sent_data' => $test_data,
        'timestamp' => date('Y-m-d H:i:s')
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ], JSON_PRETTY_PRINT);
}
?>