<?php
// Simular el contexto de un lead real
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['user_name'] = 'Usuario de Prueba';

// Datos simulados de un lead
$lead = [
    'id' => 123,
    'first_name' => 'Juan',
    'last_name' => 'Pérez',
    'email' => 'juan.perez@ejemplo.com',
    'phone' => '+1234567890',
    'company' => 'Empresa Ejemplo',
    'status' => 'contacted',
    'priority' => 'high',
    'country' => 'España'
];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Prueba Modal de Cita - Contexto Real</title>
    <link rel="stylesheet" href="public/style.css">
    <style>
        body { 
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
            padding: 40px; 
            background: #f5f7fa; 
        }
        .test-container { 
            max-width: 800px; 
            margin: 0 auto; 
            background: white; 
            padding: 40px; 
            border-radius: 12px; 
            box-shadow: 0 4px 20px rgba(0,0,0,0.1); 
        }
        .lead-card { 
            background: #f8f9fa; 
            padding: 20px; 
            border-radius: 8px; 
            margin: 20px 0; 
            border-left: 4px solid #007bff; 
        }
        .test-button { 
            background: #007bff; 
            color: white; 
            border: none; 
            padding: 12px 24px; 
            border-radius: 6px; 
            cursor: pointer; 
            font-size: 16px; 
            margin: 10px 5px; 
        }
        .test-button:hover { 
            background: #0056b3; 
        }
        .debug-info { 
            margin-top: 30px; 
            padding: 20px; 
            background: #e9ecef; 
            border-radius: 8px; 
            font-family: monospace; 
            font-size: 14px; 
        }
        .success { color: #28a745; }
        .error { color: #dc3545; }
    </style>
</head>
<body>
    <div class="test-container">
        <h1>🧪 Prueba Modal de Cita - Contexto Real</h1>
        
        <div class="lead-card">
            <h3>Lead de Prueba</h3>
            <p><strong>ID:</strong> <?= $lead['id'] ?></p>
            <p><strong>Nombre:</strong> <?= htmlspecialchars($lead['first_name'] . ' ' . $lead['last_name']) ?></p>
            <p><strong>Email:</strong> <?= htmlspecialchars($lead['email']) ?></p>
            <p><strong>Estado:</strong> <?= htmlspecialchars($lead['status']) ?></p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <button class="test-button" onclick="testAppointmentModal()">
                🗓️ Probar Modal de Cita
            </button>
            
            <button class="test-button" onclick="testProfixCRM()">
                🔍 Verificar ProfixCRM
            </button>
            
            <button class="test-button" onclick="clearDebug()">
                🧹 Limpiar Debug
            </button>
        </div>
        
        <div id="debug-info" class="debug-info">
            <h3>🔍 Información de Debug:</h3>
            <div id="debug-content">
                Esperando interacción...
            </div>
        </div>
    </div>

    <!-- Cargar los scripts necesarios -->
    <script src="public/script.js"></script>
    
    <script>
        // Función de logging
        function log(message, type = 'info') {
            const debugContent = document.getElementById('debug-content');
            const timestamp = new Date().toLocaleTimeString();
            const className = type === 'error' ? 'error' : (type === 'success' ? 'success' : '');
            debugContent.innerHTML += `<div class="${className}" style="margin: 5px 0;"><strong>${timestamp}:</strong> ${message}</div>`;
        }
        
        // Función para probar el modal de cita
        function testAppointmentModal() {
            log('=== Iniciando prueba del modal de cita ===');
            
            try {
                const clientName = '<?= htmlspecialchars($lead['first_name'] . ' ' . $lead['last_name']) ?>';
                const leadId = <?= $lead['id'] ?>;
                
                log(`Cliente: ${clientName}, Lead ID: ${leadId}`);
                
                // Verificar disponibilidad de ProfixCRM
                if (window.ProfixCRM && typeof window.ProfixCRM.openAppointmentAssistant === 'function') {
                    log('✅ ProfixCRM.openAppointmentAssistant está disponible', 'success');
                    
                    // Abrir el modal
                    window.ProfixCRM.openAppointmentAssistant({
                        clientName: clientName,
                        leadId: leadId
                    });
                    
                    log('✅ Modal abierto exitosamente', 'success');
                } else {
                    log('❌ ProfixCRM u openAppointmentAssistant no están disponibles', 'error');
                    
                    // Verificar qué está disponible
                    if (window.ProfixCRM) {
                        log(`Funciones en ProfixCRM: ${Object.keys(window.ProfixCRM).join(', ')}`);
                    } else {
                        log('window.ProfixCRM no existe');
                    }
                    
                    // Intentar ver si existe globalmente
                    if (typeof openAppointmentAssistant === 'function') {
                        log('✅ openAppointmentAssistant existe globalmente');
                        openAppointmentAssistant({
                            clientName: clientName,
                            leadId: leadId
                        });
                        log('✅ Modal abierto desde función global', 'success');
                    } else {
                        log('❌ openAppointmentAssistant no existe globalmente', 'error');
                    }
                }
            } catch (error) {
                log(`❌ Error al abrir modal: ${error.message}`, 'error');
                console.error('Error completo:', error);
            }
        }
        
        // Función para verificar ProfixCRM
        function testProfixCRM() {
            log('=== Verificando ProfixCRM ===');
            
            log(`window existe: ${typeof window !== 'undefined'}`);
            log(`window.ProfixCRM existe: ${typeof window.ProfixCRM !== 'undefined'}`);
            
            if (window.ProfixCRM) {
                log(`Tipo de ProfixCRM: ${typeof window.ProfixCRM}`);
                log(`Funciones en ProfixCRM: ${Object.keys(window.ProfixCRM).join(', ')}`);
                log(`openAppointmentAssistant existe: ${typeof window.ProfixCRM.openAppointmentAssistant === 'function'}`);
                
                if (typeof window.ProfixCRM.openAppointmentAssistant === 'function') {
                    log('✅ Todo está correcto con ProfixCRM', 'success');
                } else {
                    log('❌ openAppointmentAssistant no es una función en ProfixCRM', 'error');
                }
            } else {
                log('❌ ProfixCRM no está definido', 'error');
                
                // Buscar en objetos globales
                const globalFunctions = [];
                for (const key in window) {
                    if (typeof window[key] === 'function' && key.toLowerCase().includes('appointment')) {
                        globalFunctions.push(key);
                    }
                }
                log(`Funciones de appointment globales: ${globalFunctions.join(', ') || 'ninguna'}`);
            }
        }
        
        // Función para limpiar el debug
        function clearDebug() {
            document.getElementById('debug-content').innerHTML = '<div style="color: #666;">Debug limpiado. Esperando interacción...</div>';
        }
        
        // Verificación inicial
        window.addEventListener('load', function() {
            log('=== Página cargada ===');
            log(`URL actual: ${window.location.href}`);
            log(`Script cargado: ${typeof window.ProfixCRM !== 'undefined' ? 'Sí' : 'No'}`);
            
            setTimeout(testProfixCRM, 1000);
        });
    </script>
</body>
</html>