<?php
// Test AJAX con sesión activa
session_start();

// Simular sesión activa (como si fuera desde el navegador)
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['username'] = 'admin';
    $_SESSION['user_name'] = 'Admin User';
    $_SESSION['login_time'] = time();
}

echo "<h1>Test AJAX con Sesión Activa</h1>";
echo "<h3>Estado de Sesión:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h3>Test JavaScript AJAX (como en el navegador):</h3>";
?>

<button onclick="testPagination()">Probar Paginación Lead ID 3</button>
<div id="result"></div>

<script>
function testPagination() {
    const resultDiv = document.getElementById('result');
    resultDiv.innerHTML = 'Cargando...';
    
    // Esta es exactamente la misma petición que hace el navegador
    fetch('modules/leads/load_activities_ajax.php?lead_id=3&page=1', {
        method: 'GET',
        credentials: 'same-origin', // Incluir cookies de sesión
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        console.log('Response status:', response.status);
        return response.json();
    })
    .then(data => {
        console.log('Response data:', data);
        resultDiv.innerHTML = '<h4>Respuesta:</h4><pre>' + JSON.stringify(data, null, 2) + '</pre>';
    })
    .catch(error => {
        console.error('Error:', error);
        resultDiv.innerHTML = '<h4>Error:</h4><pre>' + error.message + '</pre>';
    });
}

// Auto-ejecutar al cargar
window.onload = function() {
    testPagination();
};
</script>

<h3>Test directo PHP (simulando la misma sesión):</h3>
<?php
// Test directo con la misma sesión
$lead_id = 3;
$page = 1;

echo "<p><strong>Probando directamente:</strong> load_activities_ajax.php?lead_id=$lead_id&page=$page</p>";

// Simular la petición interna
$_GET['lead_id'] = $lead_id;
$_GET['page'] = $page;

// Capturar la salida del endpoint
ob_start();
include 'modules/leads/load_activities_ajax.php';
$response = ob_get_clean();

echo "<h4>Respuesta PHP directa:</h4>";
echo "<pre>";
echo htmlspecialchars($response);
echo "</pre>";

// Intentar decodificar JSON
$json_data = json_decode($response, true);
if ($json_data) {
    echo "<h4>JSON Decodificado:</h4>";
    echo "<pre>";
    print_r($json_data);
    echo "</pre>";
} else {
    echo "<p><strong>Error:</strong> No se pudo decodificar el JSON</p>";
}
?>