<!DOCTYPE html>
<html>
<head>
    <title>Debug Simple</title>
</head>
<body>
    <h1>Debug Simple - Verificación de Script</h1>
    
    <div id="results"></div>
    
    <script>
        function check() {
            const results = document.getElementById('results');
            results.innerHTML = '';
            
            // Verificar paso a paso
            results.innerHTML += '<p>1. ¿window existe? ' + (typeof window !== 'undefined') + '</p>';
            results.innerHTML += '<p>2. ¿ProfixCRM existe? ' + (typeof window.ProfixCRM !== 'undefined') + '</p>';
            
            if (window.ProfixCRM) {
                results.innerHTML += '<p>3. Funciones en ProfixCRM: ' + Object.keys(window.ProfixCRM).join(', ') + '</p>';
                results.innerHTML += '<p>4. ¿openAppointmentAssistant existe? ' + (typeof window.ProfixCRM.openAppointmentAssistant === 'function') + '</p>';
            } else {
                results.innerHTML += '<p style="color: red;">3. ¡ProfixCRM no está definido!</p>';
            }
            
            // Verificar si hay errores globales
            if (typeof openAppointmentAssistant === 'function') {
                results.innerHTML += '<p style="color: green;">5. openAppointmentAssistant existe globalmente</p>';
            } else {
                results.innerHTML += '<p style="color: red;">5. openAppointmentAssistant NO existe globalmente</p>';
            }
        }
        
        // Verificar después de que todo se cargue
        setTimeout(check, 1000);
        setTimeout(check, 3000);
    </script>
    
    <button onclick="check()" style="margin-top: 20px; padding: 10px;">Verificar de nuevo</button>
    
    <!-- Cargar el script -->
    <script src="public/script.js"></script>
</body>
</html>