<?php
/**
 * Script para configurar las tablas del WebTrader
 */

require_once 'database/connection.php';

try {
    $db = getDB();
    
    echo "Configurando base de datos del WebTrader...\n";
    
    // Leer el archivo SQL
    $sql = file_get_contents('database/webtrader_schema.sql');
    if (!$sql) {
        throw new Exception("No se pudo leer webtrader_schema.sql");
    }
    
    // Dividir en statements
    $statements = explode(';', $sql);
    $executed = 0;
    
    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement) && !str_starts_with($statement, '--')) {
            try {
                $db->execute($statement);
                $executed++;
                echo "✓ Ejecutado: " . substr($statement, 0, 50) . "...\n";
            } catch (Exception $e) {
                // Ignorar errores de duplicados
                if (strpos($e->getMessage(), 'already exists') === false && 
                    strpos($e->getMessage(), 'Duplicate entry') === false) {
                    echo "⚠ Warning: " . $e->getMessage() . "\n";
                }
            }
        }
    }
    
    echo "\n✅ Configuración completada. Statements ejecutados: $executed\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>