<?php
echo "=== TEST AISLADO ===\n";

// Test completamente aislado de la función getFinageAPI
$apiKey = null;

// Check environment variable first
if (isset($_ENV['FINAGE_API_KEY'])) {
    $apiKey = $_ENV['FINAGE_API_KEY'];
    echo "API key from ENV: $apiKey\n";
}

// Check configuration file with correct path
$configPath = __DIR__ . '/../../../config/finage_config.php';
echo "Config path: $configPath\n";
echo "File exists: " . (file_exists($configPath) ? 'YES' : 'NO') . "\n";

if (!$apiKey && file_exists($configPath)) {
    // Clear any potential include cache
    if (function_exists('opcache_invalidate')) {
        opcache_invalidate($configPath, true);
    }
    
    $config = include $configPath;
    echo "Config type: " . gettype($config) . "\n";
    echo "Config is array: " . (is_array($config) ? 'YES' : 'NO') . "\n";
    
    if (is_array($config)) {
        echo "Config keys: " . implode(', ', array_keys($config)) . "\n";
        echo "Has api_key: " . (isset($config['api_key']) ? 'YES' : 'NO') . "\n";
        
        if (isset($config['api_key'])) {
            $apiKey = $config['api_key'];
            echo "API key from config: $apiKey\n";
            echo "API key length: " . strlen($apiKey) . "\n";
            echo "API key type: " . gettype($apiKey) . "\n";
        }
    }
}

echo "Final API key: " . ($apiKey ?? 'NULL') . "\n";
echo "API key is empty: " . (empty($apiKey) ? 'YES' : 'NO') . "\n";
echo "API key is null: " . (is_null($apiKey) ? 'YES' : 'NO') . "\n";

// Use demo key if no key is configured
if (!$apiKey || trim($apiKey) === '' || $apiKey === 'YOUR_FINAGE_API_KEY_HERE') {
    echo "Using placeholder key\n";
    $apiKey = 'YOUR_FINAGE_API_KEY_HERE';
} else {
    echo "Using valid API key: " . substr($apiKey, 0, 10) . '...' . "\n";
}

echo "Result API key: $apiKey\n";
?>