<?php
// Test directo de getFinageAPI con logging detallado
require_once '../finage_api.php';

echo "=== TEST DIRECTO DE getFinageAPI ===\n";

// Habilitar logging de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

// Crear un log personalizado
$logFile = __DIR__ . '/debug.log';
file_put_contents($logFile, "=== INICIO DEBUG ===\n", FILE_APPEND);

// Función personalizada para logging
function debugLog($message) {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND);
    echo "$message\n";
}

debugLog("Iniciando test de getFinageAPI");

// Llamar a getFinageAPI
debugLog("Llamando a getFinageAPI()...");
$finageAPI = getFinageAPI();
debugLog("getFinageAPI() completado");

// Verificar el resultado
$reflection = new ReflectionClass($finageAPI);
$apiKeyProperty = $reflection->getProperty('apiKey');
$apiKeyProperty->setAccessible(true);
$actualApiKey = $apiKeyProperty->getValue($finageAPI);

debugLog("API Key resultante: $actualApiKey");

// Leer el log de errores para ver qué pasó
debugLog("Contenido del log de debug:");
if (file_exists($logFile)) {
    $logContent = file_get_contents($logFile);
    echo $logContent;
}

echo "\n=== FIN TEST ===\n";
?>