<?php
echo "=== TEST DIRECTO DE API KEY ===\n";

// Test directo de la función getFinageAPI
require_once '../finage_api.php';

// Simular exactamente lo que hace getFinageAPI
$apiKey = null;

// Check environment variable first
if (isset($_ENV['FINAGE_API_KEY'])) {
    $apiKey = $_ENV['FINAGE_API_KEY'];
    echo "API Key from ENV: $apiKey\n";
}

// Check configuration file with correct path
$configPath = __DIR__ . '/../../../config/finage_config.php';
echo "Config path: $configPath\n";
echo "File exists: " . (file_exists($configPath) ? 'YES' : 'NO') . "\n";

if (!$apiKey && file_exists($configPath)) {
    $config = include $configPath;
    $apiKey = $config['api_key'] ?? null;
    echo "API Key from config: $apiKey\n";
    echo "Config array: " . print_r($config, true) . "\n";
}

// Use demo key if no key is configured
if (!$apiKey) {
    echo "No API key found, using placeholder\n";
    $apiKey = 'YOUR_FINAGE_API_KEY_HERE';
} else {
    echo "Using API key: $apiKey\n";
}

// Create FinageAPI instance directly
$finageAPI = new FinageAPI($apiKey);

// Test the connection
echo "\n=== TESTING CONNECTION ===\n";
$result = $finageAPI->testConnection();
echo "Result: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";

// Test direct API call
echo "\n=== TESTING DIRECT API CALL ===\n";
$url = "https://api.finage.co.uk/last/forex/EURUSD?apikey=$apiKey";
echo "URL: $url\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n";
?>