<?php
require_once '../finage_api.php';

echo "=== DEBUG FINAGE API ===\n";

// Check config file directly
$configPath = __DIR__ . '/../../../config/finage_config.php';
echo "Config path: $configPath\n";
echo "File exists: " . (file_exists($configPath) ? 'YES' : 'NO') . "\n";

if (file_exists($configPath)) {
    $config = include $configPath;
    echo "Config contents: " . json_encode($config, JSON_PRETTY_PRINT) . "\n";
    echo "API Key from config file: " . ($config['api_key'] ?? 'NOT FOUND') . "\n";
}

// Debug the getFinageAPI function step by step
echo "\n=== DEBUGGING getFinageAPI() ===\n";

// Check environment variable
$envKey = $_ENV['FINAGE_API_KEY'] ?? null;
echo "Environment variable FINAGE_API_KEY: " . ($envKey ? $envKey : 'NOT SET') . "\n";

// Check configuration file loading in getFinageAPI
$configPath2 = __DIR__ . '/../../../config/finage_config.php';
echo "Config path in getFinageAPI: $configPath2\n";
echo "File exists for getFinageAPI: " . (file_exists($configPath2) ? 'YES' : 'NO') . "\n";

if (file_exists($configPath2)) {
    $config2 = include $configPath2;
    $apiKeyFromConfig = $config2['api_key'] ?? null;
    echo "API Key from config in getFinageAPI: " . ($apiKeyFromConfig ? $apiKeyFromConfig : 'NOT FOUND') . "\n";
}

// Test the getFinageAPI function with error reporting
echo "\n=== TESTING getFinageAPI() WITH ERROR REPORTING ===\n";
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Clear any output buffering
if (ob_get_level()) {
    ob_end_flush();
}

$finageAPI = getFinageAPI();

// Use reflection to access private properties
$reflection = new ReflectionClass($finageAPI);
$apiKeyProperty = $reflection->getProperty('apiKey');
$apiKeyProperty->setAccessible(true);
$configProperty = $reflection->getProperty('config');
$configProperty->setAccessible(true);

echo "API Key being used by FinageAPI: " . $apiKeyProperty->getValue($finageAPI) . "\n";
echo "Config loaded by FinageAPI: " . json_encode($configProperty->getValue($finageAPI), JSON_PRETTY_PRINT) . "\n";

// Test connection
$result = $finageAPI->testConnection();
echo "Test connection result: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
?>