<?php
/**
 * Archivo de prueba para acceder al WebTrader
 * Simula la autenticación de un cliente para testing
 */

session_start();
require_once '../../database/connection.php';

// Obtener un cliente de prueba de la base de datos
$db = getDB();
$client = $db->selectOne(
    "SELECT id, email, first_name, last_name, status, desk_id 
     FROM clients 
     WHERE status = 'active' 
     LIMIT 1"
);

if (!$client) {
    // Si no hay clientes, crear uno de prueba
    $clientData = [
        'first_name' => 'Cliente',
        'last_name' => 'Prueba',
        'email' => 'cliente.prueba@webtrader.com',
        'phone' => '+1234567890',
        'status' => 'active',
        'desk_id' => 1,
        'created_at' => date('Y-m-d H:i:s')
    ];
    
    $db->execute("INSERT INTO clients (first_name, last_name, email, phone, status, desk_id, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)", [
        $clientData['first_name'],
        $clientData['last_name'],
        $clientData['email'],
        $clientData['phone'],
        $clientData['status'],
        $clientData['desk_id'],
        $clientData['created_at']
    ]);
    
    $clientId = $db->lastInsertId();
    
    if ($clientId) {
        $client = [
            'id' => $clientId,
            'first_name' => $clientData['first_name'],
            'last_name' => $clientData['last_name'],
            'email' => $clientData['email'],
            'status' => $clientData['status'],
            'desk_id' => $clientData['desk_id']
        ];
        
        echo "<div style='background: #d4edda; color: #155724; padding: 10px; margin: 10px; border-radius: 5px;'>";
        echo "✅ Cliente de prueba creado exitosamente<br>";
        echo "ID: {$client['id']}<br>";
        echo "Nombre: {$client['first_name']} {$client['last_name']}<br>";
        echo "Email: {$client['email']}";
        echo "</div>";
    } else {
        die('<div style="background: #f8d7da; color: #721c24; padding: 10px; margin: 10px; border-radius: 5px;">❌ Error creando cliente de prueba</div>');
    }
}

// Crear sesión de cliente
$_SESSION['client_id'] = $client['id'];
$_SESSION['client_name'] = $client['first_name'] . ' ' . $client['last_name'];
$_SESSION['client_email'] = $client['email'];
$_SESSION['client_desk_id'] = $client['desk_id'];

echo "<div style='background: #cce5ff; color: #004085; padding: 15px; margin: 10px; border-radius: 5px;'>";
echo "<h3>🚀 Sesión de Cliente Iniciada</h3>";
echo "<strong>Cliente ID:</strong> {$client['id']}<br>";
echo "<strong>Nombre:</strong> {$_SESSION['client_name']}<br>";
echo "<strong>Email:</strong> {$_SESSION['client_email']}<br>";
echo "<strong>Desk ID:</strong> {$_SESSION['client_desk_id']}<br><br>";
echo "<a href='index.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>🎯 Acceder al WebTrader</a>";
echo "</div>";

echo "<div style='background: #fff3cd; color: #856404; padding: 10px; margin: 10px; border-radius: 5px;'>";
echo "<strong>📊 Estado de Servidores:</strong><br>";
echo "• WebSocket Server: ws://localhost:8080 ✅<br>";
echo "• WebTrader Server: http://localhost:8081 ✅<br>";
echo "• Actualizaciones en tiempo real: Activas ✅";
echo "</div>";

echo "<div style='background: #e2e3e5; color: #383d41; padding: 10px; margin: 10px; border-radius: 5px;'>";
echo "<strong>🔧 Funcionalidades a Probar:</strong><br>";
echo "1. Conexión WebSocket en tiempo real<br>";
echo "2. Actualizaciones de precios automáticas<br>";
echo "3. Gráficas interactivas<br>";
echo "4. Colocación de órdenes<br>";
echo "5. Visualización de posiciones<br>";
echo "6. Market Watch con precios en vivo";
echo "</div>";
?>