<?php
session_start();
// Definir BASE_PATH y helpers para rutas dinámicas
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/connection.php';
require_once BASE_PATH . '/modules/shared/helpers.php';

// Verificar acceso por token desde client_access.php
if (isset($_GET['token']) && isset($_SESSION['webtrader_token']) && $_GET['token'] === $_SESSION['webtrader_token']) {
    // Acceso válido desde portal de cliente
    $webtraderConfig = $_SESSION['webtrader_config'] ?? null;
    if (!$webtraderConfig) {
        header('Location: ' . module_url('client_portal/login.php') . '?message=invalid_session');
        exit;
    }
} else {
    // Permitir acceso público sin sesión
    if (!isset($_SESSION['client_id'])) {
        $webtraderConfig = [
            'guest' => true,
            'client_id' => null,
            'client_name' => 'Invitado',
            'client_email' => null,
            'accounts' => [],
        // Configuración de puertos: usar hostname dinámico desde el navegador
        // No hardcodear URL completa del WebSocket
        'websocket_port' => 8082,
            'default_symbols' => ['EURUSD', 'GBPUSD', 'USDJPY', 'USDCHF', 'AUDUSD', 'USDCAD', 'NZDUSD', 'EURJPY'],
            'theme' => 'dark',
            'language' => 'es',
            'demo_mode' => true,
            'mw_refresh_ms' => 500,
            'mw_smooth_steps' => 6
        ];
    } else {
        // Verificar que el cliente esté activo
        $db = getDB();
        $client = $db->selectOne(
            "SELECT id, email, first_name, last_name, status, desk_id 
             FROM clients 
             WHERE id = ? AND status = 'active'",
            [$_SESSION['client_id']]
        );
        if (!$client) {
            session_destroy();
            header('Location: ' . module_url('client_portal/login.php') . '?error=account_inactive');
            exit;
        }
        // Almacenar información del cliente en la sesión
        $_SESSION['client_name'] = $client['first_name'] . ' ' . $client['last_name'];
        $_SESSION['client_email'] = $client['email'];
        $_SESSION['client_desk_id'] = $client['desk_id'];
        $_SESSION['client_status'] = 'active';
        // Crear configuración básica si no existe
        $webtraderConfig = [
            'client_id' => $_SESSION['client_id'],
            'client_name' => $_SESSION['client_name'],
            'client_email' => $_SESSION['client_email'],
            'accounts' => [],
        // Configuración de puertos: usar hostname dinámico desde el navegador
        'websocket_port' => 8082,
            'default_symbols' => ['EURUSD', 'GBPUSD', 'USDJPY', 'USDCHF', 'AUDUSD', 'USDCAD', 'NZDUSD', 'EURJPY'],
            'theme' => 'dark',
            'language' => 'es',
            'demo_mode' => true,
            'mw_refresh_ms' => 500,
            'mw_smooth_steps' => 6
        ];
    }
}

$page_title = 'WebTrader - ' . ($webtraderConfig['client_name'] ?? 'Cliente');

// Usar el layout específico del WebTrader
require_once 'webtrader_layout.php';
?>
