<?php
/**
 * API Endpoint para datos históricos
 * Proporciona datos históricos para gráficas usando Finage API
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../finage_api.php';

try {
    // Obtener parámetros
    $symbol = $_GET['symbol'] ?? 'EURUSD';
    $period = $_GET['period'] ?? '1day';
    $limit = intval($_GET['limit'] ?? 100);
    $type = $_GET['type'] ?? 'forex';
    
    // Validar parámetros
    $validPeriods = ['1min', '5min', '15min', '30min', '1hour', '4hour', '1day', '1week', '1month'];
    if (!in_array($period, $validPeriods)) {
        throw new Exception('Período no válido');
    }
    
    if ($limit < 1 || $limit > 1000) {
        throw new Exception('Límite debe estar entre 1 y 1000');
    }
    
    // Inicializar Finage API
    $finageAPI = getFinageAPI();
    
    // Obtener datos históricos
    if (in_array($period, ['1min', '5min', '15min', '30min', '1hour'])) {
        // Usar método intraday para períodos cortos
        $historicalData = $finageAPI->getIntradayData($symbol, $period, $limit, $type);
    } else {
        // Usar método estándar para períodos largos
        $historicalData = $finageAPI->getHistoricalData($symbol, $period, $limit, $type);
    }
    
    // Sin fallback simulado: si no hay datos reales, devolver arreglo vacío
    
    // Respuesta exitosa
    echo json_encode([
        'success' => true,
        'symbol' => $symbol,
        'period' => $period,
        'type' => $type,
        'count' => count($historicalData),
        'data' => $historicalData
    ]);
    
} catch (Exception $e) {
    // Respuesta de error
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

// Eliminado: no se generan datos históricos simulados
