<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../../database/connection.php';
try {
    if (!$pdo) throw new Exception('Sin conexión PDO');
    $dbName = $pdo->query('SELECT DATABASE()')->fetchColumn();
    $stmt = $pdo->prepare("SELECT TRIGGER_NAME, EVENT_MANIPULATION AS event, EVENT_OBJECT_TABLE AS tbl, ACTION_TIMING AS timing, ACTION_STATEMENT AS body FROM information_schema.TRIGGERS WHERE TRIGGER_SCHEMA = ? AND EVENT_OBJECT_TABLE IN ('trading_positions','trading_accounts') ORDER BY EVENT_OBJECT_TABLE, TRIGGER_NAME");
    $stmt->execute([$dbName]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success'=>true,'database'=>$dbName,'triggers'=>$rows]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
?>
