<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../../database/connection.php';
try {
    if (!$pdo) throw new Exception('Sin conexión PDO');
    $dbName = $pdo->query('SELECT DATABASE()')->fetchColumn();
    $tables = [];
    foreach (['trading_accounts','client_accounts'] as $tbl) {
        $stmt = $pdo->prepare("SHOW COLUMNS FROM `$tbl`");
        try {
            $stmt->execute();
            $cols = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $tables[$tbl] = $cols ?: [];
        } catch (Throwable $e) {
            $tables[$tbl] = ['error' => $e->getMessage()];
        }
    }
    echo json_encode(['success'=>true,'database'=>$dbName,'tables'=>$tables]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
?>
