<?php if (!isset($rows)) { $rows = []; } ?>
<?php if (!isset($message)) { $message = ''; } ?>
<?php $integrations = isset($availableIntegrations) ? $availableIntegrations : []; ?>
<?php $pmTemplates = [
  'big4pay' => [
    'label' => 'Big4pay',
    'config' => '{"api":"big4pay","endpoint":"https://api.big4pay.com","auth":{"username":"","password":""}}'
  ],
  'voiso' => [
    'label' => 'Voiso',
    'config' => '{"api":"voiso","endpoint":"https://api.voiso.com","auth":{"token":""}}'
  ]
]; ?>
<div class="premium-content-area">
  <div class="payments-container">
    <div class="roles-header">
        <div class="header-left">
            <h1 class="page-title">
                <svg class="title-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <rect x="2" y="4" width="20" height="14" rx="2" ry="2"/>
                    <line x1="2" y1="10" x2="22" y2="10"/>
                </svg>
                Payment Methods
            </h1>
            <p class="page-subtitle">Configura proveedores y métodos de pago integrados.</p>
        </div>
        <div class="header-actions">
            <button class="btn-primary btn-size-md" type="button" onclick="openPmWizard()">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="12" y1="5" x2="12" y2="19"/>
                    <line x1="5" y1="12" x2="19" y2="12"/>
                </svg>
                Crear Payment Method
            </button>
        </div>
    </div>
    <?php if ($message): ?><div class="notice success"><?php echo htmlspecialchars($message); ?></div><?php endif; ?>

    <div class="card" style="width:100%;">
        <div class="card-header d-flex justify-between align-center">
            <h2 class="card-title">Listado de Payment Methods</h2>
        </div>
        <div class="card-body">
        <table class="table data-table">
            <thead>
                <tr>
                    <th>Nombre</th><th>Display</th><th>Proveedor</th><th>Categoría</th><th>Tipo</th><th>Activo</th><th style="text-align:right">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rows as $r): ?>
                <tr>
                    
                    <td><?php echo htmlspecialchars($r['name']); ?></td>
                    <td><?php echo htmlspecialchars($r['display_name']); ?></td>
                    <td><?php echo htmlspecialchars($r['provider_key']); ?></td>
                    <td><?php echo htmlspecialchars($r['category']); ?></td>
                    <td><?php echo htmlspecialchars($r['type']); ?></td>
                    <td><?php echo ((int)$r['is_active']===1)?'Sí':'No'; ?></td>
                    <td class="actions-cell">
                      <?php $isActive = (int)($r['is_active'] ?? 0) === 1; ?>
                      <button type="button" class="icon-btn <?php echo $isActive ? 'inactive' : 'success'; ?>" title="<?php echo $isActive ? 'Desactivar' : 'Activar'; ?>" onclick='togglePmActive(<?php echo (int)$r['id']; ?>, <?php echo $isActive ? '0' : '1'; ?>)'>
                        <?php if ($isActive): ?>
                        <svg viewBox="0 0 24 24" width="18" height="18"><path fill="currentColor" d="M12 2a1 1 0 011 1v8a1 1 0 11-2 0V3a1 1 0 011-1zm0 20a8 8 0 100-16 8 8 0 000 16z"/></svg>
                        <?php else: ?>
                        <svg viewBox="0 0 24 24" width="18" height="18"><path fill="currentColor" d="M12 2a10 10 0 1010 10A10 10 0 0012 2zm1 5h-2v6h6v-2h-4z"/></svg>
                        <?php endif; ?>
                      </button>
                      <button type="button" class="icon-btn" title="Editar" onclick='openPmEdit(this)'
                        data-id="<?php echo (int)$r['id']; ?>"
                        data-name="<?php echo htmlspecialchars($r['name']); ?>"
                        data-display_name="<?php echo htmlspecialchars($r['display_name']); ?>"
                        data-provider_key="<?php echo htmlspecialchars($r['provider_key']); ?>"
                        data-category="<?php echo htmlspecialchars($r['category']); ?>"
                        data-type="<?php echo htmlspecialchars($r['type']); ?>"
                        data-supported_currencies="<?php echo htmlspecialchars($r['supported_currencies'] ?? ''); ?>"
                        data-is_active="<?php echo (int)$r['is_active']; ?>"
                        data-api_username="<?php echo htmlspecialchars($r['api_username'] ?? ''); ?>"
                        data-api_password="<?php echo htmlspecialchars($r['api_password'] ?? ''); ?>"
                        data-api_base_url="<?php echo htmlspecialchars($r['api_base_url'] ?? ''); ?>"
                        data-api_currency="<?php echo htmlspecialchars($r['api_currency'] ?? ''); ?>"
                        data-min_amount="<?php echo htmlspecialchars($r['min_amount'] ?? ''); ?>"
                        data-max_amount="<?php echo htmlspecialchars($r['max_amount'] ?? ''); ?>"
                        data-eta_label="<?php echo htmlspecialchars($r['eta_label'] ?? ''); ?>"
                        data-checkout_redirect_url="<?php echo htmlspecialchars($r['checkout_redirect_url'] ?? ''); ?>"
                      >
                        <svg viewBox="0 0 24 24" width="18" height="18"><path fill="currentColor" d="M3 17.25V21h3.75l11-11.03-3.75-3.75L3 17.25zm2.92 2.33l-.75-.75 9.55-9.58.75.75-9.55 9.58zM20.71 7.04a1 1 0 0 0 0-1.41L18.37 3.29a1 1 0 0 0-1.41 0l-1.34 1.34 3.75 3.75 1.34-1.34z"/></svg>
                      </button>
                      <button type="button" class="icon-btn danger" title="Eliminar" onclick='deletePm(<?php echo (int)$r['id']; ?>)'>
                        <svg viewBox="0 0 24 24" width="18" height="18"><path fill="currentColor" d="M9 3h6a1 1 0 0 1 1 1v1h4v2H4V5h4V4a1 1 0 0 1 1-1zm-1 6h2v9H8V9zm6 0h2v9h-2V9z"/></svg>
                      </button>
                </td>
            </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
    </div>
  </div>
</div>
<div id="pmWizardBackdrop" class="modal-backdrop" style="display:none;">
  <div class="modal modal-premium" role="dialog" aria-modal="true" aria-labelledby="pmWizardTitle" style="max-width: 900px; width: 100%;">
    <div class="modal-header">
      <h3 id="pmWizardTitle">Asistente: Crear Payment Method</h3>
      <button class="btn-ghost btn-size-md" onclick="closePmWizard()">✕</button>
    </div>
    <div class="modal-body">
      <div id="pmWizardSteps" class="wizard-stepper">
        <div class="wizard-step-item active" data-step="1"><span class="step-index">1</span><span class="step-title">Proveedor</span></div>
        <div class="wizard-step-item" data-step="2"><span class="step-index">2</span><span class="step-title">Categoría API</span></div>
        <div class="wizard-step-item" data-step="3"><span class="step-index">3</span><span class="step-title">Detalles</span></div>
        <div class="wizard-step-item" data-step="4"><span class="step-index">4</span><span class="step-title">Confirmar</span></div>
      </div>
      <div class="wizard-progress"><div class="progress-bar"><div class="progress-fill" id="wizardProgressFill" style="width:0%"></div></div></div>
      <form method="post" id="pmWizardForm" enctype="multipart/form-data">
        <input type="hidden" name="mode" id="pmMode" value="create"/>
        <input type="hidden" name="id" id="pmId" value=""/>
        <div class="wizard-pane" data-step="1">
          <div class="pane-header">
            <h4>Proveedor</h4>
            <p>Escribe el nombre del proveedor (ej. key2pay, big4pay). Si coincide con una integración, se mostrarán sus credenciales.</p>
          </div>
          <div class="form-grid">
            <div class="form-row">
              <label>Proveedor</label>
              <input name="provider_key" id="provider_key" required placeholder="Ej: key2pay" />
            </div>
            <div class="form-row">
              <label>API Controller</label>
              <select name="controller_key" id="controller_key">
                <option value="big4pay">big4pay</option>
                <option value="key2pay">key2pay</option>
              </select>
            </div>
          </div>
          <div class="provider-hint"><small id="providerDesc"></small></div>
          <div class="form-actions"><button type="button" class="btn btn-primary" onclick="goToStep(2)">Continuar</button></div>
        </div>
        <div class="wizard-pane" data-step="2" style="display:none">
          <div class="form-grid">
            <div class="form-row"><label>Categoría del API</label>
              <select name="api_category" id="apiCategory">
                <option value="Payment Method" selected>Payment Method</option>
              </select>
            </div>
          </div>
          <div class="form-actions"><button type="button" class="btn" onclick="prevStep(1)">Atrás</button> <button type="button" class="btn btn-primary" onclick="goToStep(3)">Continuar</button></div>
        </div>
        <div class="wizard-pane" data-step="3" style="display:none">
          <div class="form-grid">
            <div class="form-row"><label>Nombre</label><input name="name" required placeholder="Ej: Big4pay Card"></div>
            <div class="form-row"><label>Display</label><input name="display_name"></div>
            <div class="form-row"><label>Categoría</label>
              <select name="category">
                <option value="Payment Method" selected>Payment Method</option>
                <option value="card">Card</option>
                <option value="bank">Bank</option>
                <option value="paypal">PayPal</option>
                <option value="crypto">Crypto</option>
              </select>
            </div>
            <div class="form-row"><label>Tipo</label>
              <select name="type"><option value="deposit">Depósito</option><option value="withdraw">Retiro</option><option value="both">Ambas</option></select>
            </div>
            
            <div class="form-row"><label>Checkout URL</label><input name="checkout_redirect_url" id="checkoutRedirect" placeholder="Ej: http://localhost:8091/simple_crm/index.php?module=checkout"></div>
            <div class="form-row"><label>Logo</label><input type="file" name="logo" id="logoInput" accept="image/*"></div>
            <div class="form-row"><div class="logo-preview" id="logoPreview" style="display:none;"><img id="logoImg" alt="Logo"/></div></div>
            
            <div id="credBig4pay" class="credentials-section" style="display:none; grid-column: span 12;">
              <div class="form-row"><label>Big4pay Username</label><input type="text" name="big4pay_username" id="big4payUser" placeholder="Usuario de Big4pay"></div>
              <div class="form-row"><label>Big4pay Password</label><input type="password" name="big4pay_password" id="big4payPass" placeholder="Contraseña de Big4pay"></div>
            </div>
            <div id="credKey2Pay" class="credentials-section" style="display:none; grid-column: span 12;">
              <div class="form-row"><label>Key2Pay Base URL</label><input type="text" name="key2pay_api_base_url" id="key2payBase" placeholder="https://sandbox-api.key2pay.io/v1"></div>
              <div class="form-row"><label>Key2Pay Username</label><input type="text" name="key2pay_username" id="key2payUser" placeholder="Usuario de Key2Pay"></div>
              <div class="form-row"><label>Key2Pay Password</label><input type="password" name="key2pay_password" id="key2payPass" placeholder="Contraseña de Key2Pay"></div>
              <div class="form-row"><label>Key2Pay Currency</label><input type="text" name="key2pay_currency" id="key2payCurr" placeholder="USD"></div>
            </div>
            <div class="form-row"><label>Activo</label><input type="checkbox" name="is_active" checked></div>
          </div>
          <div class="form-actions"><div class="form-error" id="wizardError" style="display:none;"></div><button type="button" class="btn" onclick="prevStep(2)">Atrás</button> <button type="button" class="btn btn-primary" onclick="goToStep(4)">Continuar</button></div>
        </div>
        <div class="wizard-pane" data-step="4" style="display:none">
          <div class="pane-header">
            <h4>Resumen</h4>
            <p>Verifica la configuración antes de guardar.</p>
          </div>
          <div class="summary-grid">
            <div><strong>Proveedor:</strong> <span id="sumProvider">-</span></div>
            <div><strong>Categoría API:</strong> <span id="sumApiCat">-</span></div>
            <div><strong>Nombre:</strong> <span id="sumName">-</span></div>
            <div><strong>Display:</strong> <span id="sumDisplay">-</span></div>
            <div><strong>Categoría Método:</strong> <span id="sumCategory">-</span></div>
            <div><strong>Tipo:</strong> <span id="sumType">-</span></div>
            <div><strong>Activo:</strong> <span id="sumActive">-</span></div>
          </div>
          <div class="form-actions"><button type="button" class="btn" onclick="prevStep(3)">Atrás</button> <button class="btn btn-primary" type="submit" onclick="fillSummary(true)">Guardar</button></div>
        </div>
      </form>
    </div>
  </div>
</div>
<script>
window.PM_PROVIDER_TEMPLATES = <?php echo json_encode($pmTemplates); ?>;
function goToStep(n){
  if (!validateStep(n)) return;
  document.querySelectorAll('.wizard-pane').forEach(p=>p.style.display='none');
  const pane = document.querySelector(`.wizard-pane[data-step="${n}"]`);
  if (pane) pane.style.display='block';
  document.querySelectorAll('#pmWizardSteps .wizard-step-item').forEach(s=>s.classList.remove('active'));
  const stepEl = document.querySelector(`#pmWizardSteps .wizard-step-item[data-step="${n}"]`);
  if (stepEl) stepEl.classList.add('active');
  updateProgress(n);
  if (n===4) fillSummary(false);
}
function nextStep(n){ goToStep(n); }
function prevStep(n){ goToStep(n); }
function openPmWizard(){ goToStep(1); const bd = document.getElementById('pmWizardBackdrop'); if (bd) bd.style.display='block'; initProviderSelection(); }
function closePmWizard(){ const bd = document.getElementById('pmWizardBackdrop'); if (bd){ bd.style.display='none'; bd.classList.remove('open'); } document.body.classList.remove('modal-open'); }
function openPmEdit(btn){
  const bd = document.getElementById('pmWizardBackdrop');
  const mode = document.getElementById('pmMode');
  const idEl = document.getElementById('pmId');
  if (mode) mode.value = 'update';
  if (idEl) idEl.value = btn.getAttribute('data-id') || '';
  const prov = btn.getAttribute('data-provider_key') || '';
  const name = btn.getAttribute('data-name') || '';
  const display = btn.getAttribute('data-display_name') || '';
  const category = btn.getAttribute('data-category') || 'Payment Method';
  const type = btn.getAttribute('data-type') || 'deposit';
  const currs = btn.getAttribute('data-supported_currencies') || '';
  const chkRedirect = btn.getAttribute('data-checkout_redirect_url') || '';
  const active = btn.getAttribute('data-is_active') === '1';
  const u = btn.getAttribute('data-api_username') || '';
  const p = btn.getAttribute('data-api_password') || '';
  const b = btn.getAttribute('data-api_base_url') || '';
  const cur = btn.getAttribute('data-api_currency') || '';
  const min = btn.getAttribute('data-min_amount') || '';
  const max = btn.getAttribute('data-max_amount') || '';
  const eta = btn.getAttribute('data-eta_label') || '';
  const provField = document.getElementById('provider_key');
  const ctrlSel = document.getElementById('controller_key');
  if (provField) provField.value = prov;
  if (ctrlSel) ctrlSel.value = (btn.getAttribute('data-provider_key') || 'big4pay');
  initProviderSelection();
  const nameEl = document.querySelector('input[name="name"]');
  const displayEl = document.querySelector('input[name="display_name"]');
  const catEl = document.querySelector('select[name="category"]');
  const typeEl = document.querySelector('select[name="type"]');
  const currsEl = document.querySelector('input[name="supported_currencies"]');
  const chkEl = document.getElementById('checkoutRedirect');
  const activeEl = document.querySelector('input[name="is_active"]');
  const userEl = document.getElementById('big4payUser');
  const passEl = document.getElementById('big4payPass');
  const minEl = document.getElementById('minAmount');
  const maxEl = document.getElementById('maxAmount');
  const etaEl = document.getElementById('etaLabel');
  const k2BaseEl = document.getElementById('key2payBase');
  const k2UserEl = document.getElementById('key2payUser');
  const k2PassEl = document.getElementById('key2payPass');
  const k2CurrEl = document.getElementById('key2payCurr');
  if (nameEl) nameEl.value = name;
  if (displayEl) displayEl.value = display;
  if (catEl) catEl.value = category;
  if (typeEl) typeEl.value = type;
  if (currsEl) currsEl.value = currs || 'USD';
  if (chkEl) chkEl.value = chkRedirect || '';
  if (activeEl) activeEl.checked = !!active;
  if (userEl) userEl.value = u;
  if (passEl) passEl.value = p;
  if (minEl) minEl.value = min;
  if (maxEl) maxEl.value = max;
  if (etaEl) etaEl.value = eta;
  if (k2BaseEl) k2BaseEl.value = b;
  if (k2UserEl) k2UserEl.value = u;
  if (k2PassEl) k2PassEl.value = p;
  if (k2CurrEl) k2CurrEl.value = cur || 'USD';
  if (k2BaseEl) k2BaseEl.value = btn.getAttribute('data-api_base_url') || '';
  if (k2UserEl) k2UserEl.value = btn.getAttribute('data-api_username') || '';
  if (k2PassEl) k2PassEl.value = btn.getAttribute('data-api_password') || '';
  if (k2CurrEl) k2CurrEl.value = btn.getAttribute('data-api_currency') || 'USD';
  goToStep(3);
  if (bd){ bd.style.display='flex'; bd.classList.add('open'); } document.body.classList.add('modal-open');
}
function initProviderSelection(){
  const input = document.getElementById('controller_key');
  const descEl = document.getElementById('providerDesc');
  const checkoutEl = document.getElementById('checkoutRedirect');
  function apply(val){
    const key = String(val||'').trim().toLowerCase();
    const tpl = window.PM_PROVIDER_TEMPLATES[key];
    if (descEl) descEl.textContent = tpl && tpl.label ? (`Configurando: ${tpl.label}`) : (key?`Proveedor: ${key}`:'');
    const b4 = document.getElementById('credBig4pay');
    const k2 = document.getElementById('credKey2Pay');
    if (b4) b4.style.display = (key==='big4pay') ? 'grid' : 'none';
    if (k2) k2.style.display = (key==='key2pay') ? 'grid' : 'none';
    if (checkoutEl){
      const base = location.origin + (location.pathname.indexOf('/simple_crm/')!==-1 ? '/simple_crm' : '');
      const defUrl = (key==='key2pay' || key==='big4pay') ? (base + '/modules/checkout/' + key + '/index.php') : '';
      const modeEl = document.getElementById('pmMode');
      const isCreate = !modeEl || (modeEl.value !== 'update');
      if (isCreate) checkoutEl.value = defUrl;
      checkoutEl.placeholder = defUrl || checkoutEl.placeholder;
    }
  }
  if (input){ input.addEventListener('input', ()=>apply(input.value)); input.addEventListener('change', ()=>apply(input.value)); apply(input.value) }
  const logoInput = document.getElementById('logoInput');
  if (logoInput) {
    logoInput.addEventListener('change', ()=>{
      const file = logoInput.files && logoInput.files[0];
      const prev = document.getElementById('logoPreview');
      const img = document.getElementById('logoImg');
      if (file && img && prev) {
        img.src = URL.createObjectURL(file);
        prev.style.display = 'block';
      }
    });
  }
}
function updateProgress(n){
  const total = 4;
  const pct = Math.round(((n-1)/(total-1))*100);
  const fill = document.getElementById('wizardProgressFill');
  if (fill) fill.style.width = pct + '%';
}
function validateStep(n){
  const err = document.getElementById('wizardError');
  if (err) { err.style.display='none'; err.textContent=''; }
  if (n===4) {
    const name = (document.querySelector('input[name="name"]')||{}).value || '';
    try { const j = (document.getElementById('configJson')||{}).value || '{}'; JSON.parse(j); } catch(e) { if (err){ err.textContent='El JSON de Config no es válido.'; err.style.display='block'; } return false; }
    if (!name.trim()) { if (err){ err.textContent='Completa el nombre antes de continuar.'; err.style.display='block'; } return false; }
  }
  return true;
}
function fillSummary(trigger){
  const provider = (document.querySelector('input[name="provider_key"]:checked')||{}).value || '';
  const apiCat = (document.getElementById('apiCategory')||{}).value || '';
  const name = (document.querySelector('input[name="name"]')||{}).value || '';
  const display = (document.querySelector('input[name="display_name"]')||{}).value || '';
  const category = (document.querySelector('select[name="category"]')||{}).value || '';
  const type = (document.querySelector('select[name="type"]')||{}).value || '';
  const active = (document.querySelector('input[name="is_active"]')||{}).checked ? 'Sí' : 'No';
  const mapName = {big4pay:'Big4pay', voiso:'Voiso'};
  const byId = id=>document.getElementById(id);
  if (byId('sumProvider')) byId('sumProvider').textContent = mapName[provider]||provider||'-';
  if (byId('sumApiCat')) byId('sumApiCat').textContent = apiCat||'-';
  if (byId('sumName')) byId('sumName').textContent = name||'-';
  if (byId('sumDisplay')) byId('sumDisplay').textContent = display||'-';
  if (byId('sumCategory')) byId('sumCategory').textContent = category||'-';
  if (byId('sumType')) byId('sumType').textContent = type||'-';
  if (byId('sumActive')) byId('sumActive').textContent = active||'-';
  if (!trigger) return;
}
document.addEventListener('DOMContentLoaded', ()=>{
  const inputs = document.querySelectorAll('#pmWizardForm .form-row input, #pmWizardForm .form-row select, #pmWizardForm .form-row textarea');
  inputs.forEach(el=>{
    el.addEventListener('focus', ()=>{ el.classList.add('input-focus'); });
    el.addEventListener('blur', ()=>{ el.classList.remove('input-focus'); if (el.required && !String(el.value||'').trim()) el.classList.add('input-error'); else el.classList.remove('input-error'); });
  });
  const bd = document.getElementById('pmWizardBackdrop');
  if (bd){
    bd.addEventListener('click', (e)=>{ if (e.target && e.target.id === 'pmWizardBackdrop') closePmWizard() });
  }
  document.addEventListener('keyup', (e)=>{ if (e.key === 'Escape') closePmWizard() })
});
function deletePm(id){
  if(!id) return; if(!confirm('¿Eliminar este método de pago?')) return;
  const form = new FormData(); form.append('mode','delete'); form.append('id', String(id));
  fetch(location.href, { method:'POST', body: form }).then(()=>{ location.reload() }).catch(()=>{ alert('Error eliminando método') })
}
function togglePmActive(id, toActive){
  if(!id) return;
  const form = new FormData(); form.append('mode','toggle_active'); form.append('id', String(id)); form.append('is_active', String(toActive));
  fetch(location.href, { method:'POST', body: form }).then(()=>{ location.reload() }).catch(()=>{ alert('Error cambiando estado') })
}
</script>
<style>
  .premium-content-area { min-height: auto; padding-bottom: 0; }
  .payments-container { max-width: none; width: 100%; margin: 0; padding: 0 24px; }
  .roles-header { display:flex; justify-content:space-between; align-items:flex-end; margin: 8px 0 16px; }
  .roles-header .page-title { margin:0; display:flex; align-items:center; gap:.5rem; }
  .roles-header .page-subtitle { margin:0; color:#6c757d; }
  .roles-header .header-actions { display:flex; gap:.5rem; }
  .card { margin-bottom: 16px; width: 100%; }
  .card-body { overflow-x: auto; }
  .table th, .table td { white-space: nowrap; }
  .actions-cell{ display:flex; justify-content:flex-end; gap:8px; }
  .icon-btn{ border:1px solid #e5e7eb; background:#fff; color:#374151; border-radius:8px; padding:8px; display:inline-flex; align-items:center; justify-content:center; transition:box-shadow .15s ease, transform .1s ease; }
  .icon-btn:hover{ box-shadow:0 8px 18px rgba(0,0,0,.08); transform:translateY(-1px) }
  .icon-btn.danger{ color:#dc2626; border-color:#fecaca; background:#fff5f5 }
  .icon-btn.success{ color:#10b981; border-color:#a7f3d0; background:#ecfdf5 }
  .icon-btn.inactive{ color:#f59e0b; border-color:#fde68a; background:#fffbeb }
.modal-backdrop { position: fixed; inset: 0; background: rgba(0,0,0,0.35); display: none; align-items: center; justify-content: center; padding: 16px; }
.modal-backdrop.open { display:flex; }
body.modal-open { overflow:hidden; }
.modal.modal-premium { width: 100%; max-width: 920px; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.25); overflow:hidden; }
.modal.modal-premium .modal-body{ background:#ffffff; padding:16px }
.modal-header { background: linear-gradient(90deg,#0ea5e9,#14b8a6); color:#fff; padding: 14px 16px; }
.modal-header h3 { margin:0; font-weight:700; letter-spacing:.2px; }
.modal-header .btn-ghost { color:#fff; border-color: rgba(255,255,255,.4); }
  .provider-hint { margin: 8px 0; color: #6c757d; }
.wizard-stepper { display:flex; gap:12px; margin-bottom:16px; align-items:center; }
.wizard-step-item { display:flex; align-items:center; gap:8px; color:#6c757d; position:relative; padding:6px 10px; border:1px solid #e5e7eb; border-radius:999px; }
.wizard-step-item .step-index { width:24px; height:24px; border-radius:50%; display:inline-flex; align-items:center; justify-content:center; background:#e9ecef; color:#495057; font-weight:600; }
.wizard-step-item.active .step-index { background:#0d6efd; color:#fff; }
.wizard-step-item.active .step-title { color:#0d6efd; font-weight:600; }
.wizard-progress { margin: 2px 0 16px; }
.progress-bar { height: 8px; background: #eef2f7; border-radius: 999px; overflow: hidden; }
.progress-fill { height: 100%; background: linear-gradient(90deg, #0ea5e9, #14b8a6); }
  .provider-tiles { display:grid; grid-template-columns: repeat(auto-fit,minmax(160px,1fr)); gap:12px; margin: 8px 0 12px; }
  .provider-tile { border:1px solid #e5e7eb; border-radius:12px; padding:14px; cursor:pointer; display:flex; gap:10px; align-items:center; background:#f8fafc; transition:transform .12s ease, box-shadow .18s ease; }
  .provider-tile:hover { transform: translateY(-1px); box-shadow: 0 10px 24px rgba(0,0,0,.06); }
  .provider-tile input { display:none; }
  .provider-tile.active { border-color:#0d6efd; box-shadow: 0 0 0 2px rgba(13,110,253,0.15); }
  #provider_key{ width:100%; padding:12px 12px; border:1px solid #e5e7eb; border-radius:10px; background:#ffffff; font-size:14px; }
  .tile-body { display:flex; flex-direction:column; }
  .tile-title { font-weight:600; }
  .tile-sub { font-size:12px; color:#6c757d; }
  .pane-header h4 { margin:0 0 6px; }
  .pane-header p { margin:0 0 10px; color:#6c757d; }
  .summary-grid { display:grid; grid-template-columns: repeat(auto-fit,minmax(220px,1fr)); gap:8px; background:#f8f9fa; padding:12px; border-radius:8px; }
.form-grid { display:grid; grid-template-columns: repeat(12, 1fr); gap:16px; }
.form-row { display:flex; flex-direction:column; gap:6px; grid-column: span 6; }
.form-row label { font-weight:600; color:#334155; }
.form-row input[type="text"], .form-row input[type="password"], .form-row input[type="number"], .form-row input[type="file"], .form-row select, .form-row textarea { width:100%; box-sizing:border-box; height:44px; padding:10px 14px; border:1px solid #e5e7eb; border-radius:12px; background:#f9fafb; color:#111827; font-size:14px; transition:border-color .15s ease, box-shadow .15s ease; outline:none }
.modal.modal-premium .form-row input[type="text"],
.modal.modal-premium .form-row input[type="password"],
.modal.modal-premium .form-row input[type="number"],
.modal.modal-premium .form-row input[type="file"],
.modal.modal-premium .form-row select,
.modal.modal-premium .form-row textarea { border:1px solid #e5e7eb; border-radius:12px; background:#f9fafb; height:44px; }
/* Enforce identical style for name, display and checkout URL */
.modal.modal-premium input[name="name"],
.modal.modal-premium input[name="display_name"],
.modal.modal-premium #checkoutRedirect { height:44px; background:#f9fafb; border:1px solid #e5e7eb; border-radius:12px; color:#111827; }
.form-row input.input-focus, .form-row select.input-focus, .form-row textarea.input-focus { border-color:#38bdf8; box-shadow: 0 0 0 3px rgba(56,189,248,.15); }
.form-row .input-error { border-color:#ef4444; box-shadow: 0 0 0 3px rgba(239,68,68,.12); background:#f9fafb; }
@media (max-width: 1024px){ .form-row{ grid-column: span 12; } }
.form-actions { display:flex; justify-content:flex-end; gap:10px; margin-top:12px; align-items:center; }
.form-error { color:#dc3545; margin-right:auto; }
.logo-preview { border:1px dashed #cfd3d6; padding:8px; border-radius:8px; max-width:180px; }
.logo-preview img { max-width:100%; height:auto; display:block; }
/* Credentials cards */
.credentials-section{ border:1px solid #e5e7eb; border-radius:14px; padding:14px; background:#f9fafb }
.credentials-section .form-row{ grid-column: span 6 }
.modal-backdrop{ backdrop-filter: blur(2px) }
/* Buttons */
.btn.btn-primary{ background: linear-gradient(180deg,#3b82f6,#2563eb); color:#fff; border:0; border-radius:12px; padding:10px 16px }
.btn{ border-radius:12px }
  @media (max-width: 768px) { .roles-header { align-items:flex-start; } .payments-container { padding: 0 12px; } }
  .form-row input[type="file"]{ cursor:pointer }
  .form-row input[type="file"]::file-selector-button{ background: linear-gradient(180deg,#3b82f6,#2563eb); color:#fff; border:0; border-radius:10px; padding:8px 12px; margin-right:10px; cursor:pointer }
  .form-row select{ appearance:none; -webkit-appearance:none; -moz-appearance:none }
  .form-row input::placeholder, .form-row textarea::placeholder{ color:#9aa3af }
  .credentials-section .form-row input, .credentials-section .form-row select, .credentials-section .form-row textarea{ height:44px }
</style>
