<?php
// Test simple para verificar la actualización en tiempo real y paginación

// Iniciar sesión para pruebas
session_start();
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['user_name'] = 'Usuario de Prueba';
}

echo "<h1>Prueba de Actualización en Tiempo Real y Paginación</h1>";

// Verificar que el archivo AJAX existe
$ajax_file = __DIR__ . '/load_activities_ajax.php';
if (file_exists($ajax_file)) {
    echo "<p style='color: green;'>✓ Archivo load_activities_ajax.php existe</p>";
} else {
    echo "<p style='color: red;'>✗ Archivo load_activities_ajax.php no existe</p>";
}

// Verificar que view_scripts.js existe
$scripts_file = __DIR__ . '/view_scripts.js';
if (file_exists($scripts_file)) {
    echo "<p style='color: green;'>✓ Archivo view_scripts.js existe</p>";
} else {
    echo "<p style='color: red;'>✗ Archivo view_scripts.js no existe</p>";
}

// Verificar que view_content.php existe
$content_file = __DIR__ . '/view_content.php';
if (file_exists($content_file)) {
    echo "<p style='color: green;'>✓ Archivo view_content.php existe</p>";
} else {
    echo "<p style='color: red;'>✗ Archivo view_content.php no existe</p>";
}

// Verificar que add_note.php existe
$add_note_file = __DIR__ . '/add_note.php';
if (file_exists($add_note_file)) {
    echo "<p style='color: green;'>✓ Archivo add_note.php existe</p>";
} else {
    echo "<p style='color: red;'>✗ Archivo add_note.php no existe</p>";
}

echo "<h2>Resumen de cambios realizados:</h2>";
echo "<ul>";
echo "<li>✓ Eliminado window.location.reload() en saveComment()</li>";
echo "<li>✓ Agregada función loadActivitiesPage() para carga AJAX</li>";
echo "<li>✓ Creado archivo load_activities_ajax.php</li>";
echo "<li>✓ Mejorado diseño de paginación con botones numerados</li>";
echo "<li>✓ Agregada función updateActivityCount() para actualizar contadores</li>";
echo "<li>✓ Agregados estilos CSS para paginación moderna</li>";
echo "<li>✓ Actualizada paginación en view_content.php para usar AJAX</li>";
echo "</ul>";

// Verificar el contenido de view_scripts.js
echo "<h2>Verificación de funciones en view_scripts.js:</h2>";
$scripts_content = file_get_contents($scripts_file);

if (strpos($scripts_content, 'loadActivitiesPage') !== false) {
    echo "<p style='color: green;'>✓ Función loadActivitiesPage() encontrada</p>";
} else {
    echo "<p style='color: red;'>✗ Función loadActivitiesPage() no encontrada</p>";
}

if (strpos($scripts_content, 'updateActivityCount') !== false) {
    echo "<p style='color: green;'>✓ Función updateActivityCount() encontrada</p>";
} else {
    echo "<p style='color: red;'>✗ Función updateActivityCount() no encontrada</p>";
}

if (strpos($scripts_content, 'addActivityToTimeline') !== false) {
    echo "<p style='color: green;'>✓ Función addActivityToTimeline() encontrada</p>";
} else {
    echo "<p style='color: red;'>✗ Función addActivityToTimeline() no encontrada</p>";
}

// Verificar que no hay reload en saveComment
if (strpos($scripts_content, 'window.location.reload()') === false) {
    echo "<p style='color: green;'>✓ No se encontró window.location.reload() en el código</p>";
} else {
    echo "<p style='color: red;'>✗ Se encontró window.location.reload() en el código</p>";
}

echo "<h2>Instrucciones de prueba:</h2>";
echo "<ol>";
echo "<li>Abrir un lead en el navegador</li>";
echo "<li>Agregar un comentario</li>";
echo "<li>Verificar que el comentario aparece sin recargar la página</li>";
echo "<li>Probar los botones de paginación (Anterior/Siguiente)</li>";
echo "<li>Verificar que los números de página funcionan correctamente</li>";
echo "</ol>";

echo "<p><strong>Nota:</strong> Para una prueba completa, abra el navegador y acceda a un lead específico.</p>";

?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
h1, h2 { color: #333; }
.success { color: green; }
.error { color: red; }
pre { background: #f4f4f4; padding: 10px; border-radius: 4px; overflow-x: auto; }
</style>