<?php
// Test para verificar la actualización en tiempo real y paginación
require_once __DIR__ . '/../../database/config.php';
require_once __DIR__ . '/../../modules/auth/auth.php';

// Iniciar sesión para pruebas
session_start();
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['user_name'] = 'Usuario de Prueba';
}

// Obtener un lead de prueba
try {
    require_once '../../database/connection.php';
    $db = getDB();
    $lead = $db->selectOne("SELECT id, name FROM leads LIMIT 1");
    
    if (!$lead) {
        echo "No hay leads disponibles para pruebas.";
        exit;
    }
    
    $lead_id = $lead['id'];
    echo "<h1>Prueba de Actualización en Tiempo Real y Paginación</h1>";
    echo "<p>Lead de prueba: ID={$lead_id}, Nombre: " . htmlspecialchars($lead['name']) . "</p>";
    
    // Verificar que el archivo AJAX existe
    $ajax_file = __DIR__ . '/load_activities_ajax.php';
    if (file_exists($ajax_file)) {
        echo "<p style='color: green;'>✓ Archivo load_activities_ajax.php existe</p>";
    } else {
        echo "<p style='color: red;'>✗ Archivo load_activities_ajax.php no existe</p>";
    }
    
    // Probar la carga AJAX
    echo "<h2>Probando carga AJAX de actividades:</h2>";
    
    // Crear contexto de prueba
    $_GET['lead_id'] = $lead_id;
    $_GET['page'] = 1;
    
    ob_start();
    include $ajax_file;
    $response = ob_get_clean();
    
    $data = json_decode($response, true);
    if ($data && isset($data['success'])) {
        echo "<p style='color: green;'>✓ Respuesta AJAX válida recibida</p>";
        echo "<p>Total de páginas: " . $data['total_pages'] . "</p>";
        echo "<p>Total de actividades: " . $data['total_activities'] . "</p>";
        echo "<p>HTML recibido: " . strlen($data['html']) . " caracteres</p>";
        
        if (!empty($data['html'])) {
            echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px 0; background: #f9f9f9;'>";
            echo "<h3>Contenido HTML del timeline:</h3>";
            echo $data['html'];
            echo "</div>";
        }
        
        if (!empty($data['pagination_html'])) {
            echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px 0; background: #f0f0f0;'>";
            echo "<h3>HTML de paginación:</h3>";
            echo $data['pagination_html'];
            echo "</div>";
        }
    } else {
        echo "<p style='color: red;'>✗ Error en respuesta AJAX:</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
    }
    
    echo "<h2>Resumen de cambios realizados:</h2>";
    echo "<ul>";
    echo "<li>✓ Eliminado window.location.reload() en saveComment()</li>";
    echo "<li>✓ Agregada función loadActivitiesPage() para carga AJAX</li>";
    echo "<li>✓ Creado archivo load_activities_ajax.php</li>";
    echo "<li>✓ Mejorado diseño de paginación con botones numerados</li>";
    echo "<li>✓ Agregada función updateActivityCount() para actualizar contadores</li>";
    echo "<li>✓ Agregados estilos CSS para paginación moderna</li>";
    echo "<li>✓ Actualizada paginación en view_content.php para usar AJAX</li>";
    echo "</ul>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
h1, h2 { color: #333; }
.success { color: green; }
.error { color: red; }
pre { background: #f4f4f4; padding: 10px; border-radius: 4px; overflow-x: auto; }
</style>