<?php
/**
 * Test para verificar la respuesta JSON de add_note.php
 * Sin sesión activa para ver el error 401
 */

// Limpiar cualquier salida previa
ob_start();

// Incluir el archivo directamente para ver si hay salida
require_once __DIR__ . '/../../database/config.php';
require_once __DIR__ . '/../../database/connection.php';

// Forzar que no haya sesión activa
session_start();
session_destroy();

// Incluir add_note.php directamente
ob_clean();

echo "=== TEST DE RESPUESTA JSON ===\n\n";

// Capturar toda la salida
ob_start();
require_once 'add_note.php';
$output = ob_get_clean();

echo "Respuesta capturada:\n";
echo "Longitud: " . strlen($output) . " caracteres\n";
echo "Contenido: '" . $output . "'\n\n";

// Analizar la respuesta
if (empty($output)) {
    echo "⚠️ No hay salida\n";
} else {
    // Verificar si es JSON válido
    $json = json_decode($output, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "✅ JSON válido encontrado:\n";
        echo json_encode($json, JSON_PRETTY_PRINT) . "\n";
    } else {
        echo "❌ Error de JSON: " . json_last_error_msg() . "\n";
        echo "Primeros 100 caracteres: " . substr($output, 0, 100) . "\n";
        echo "Códigos de caracteres iniciales: ";
        for ($i = 0; $i < min(10, strlen($output)); $i++) {
            echo ord($output[$i]) . " ";
        }
        echo "\n";
    }
}

echo "\n=== FIN DEL TEST ===\n";