<?php
/**
 * Test Directo - Probar add_note.php desde el directorio modules/leads
 */

// Cambiar al directorio correcto
chdir(__DIR__);

// Incluir archivos necesarios
require_once '../../database/config.php';
require_once '../../database/connection.php';
session_start();

// Simular sesión
$_SESSION['user_id'] = 1;

echo "<h2>Test Directo de add_note.php</h2>\n";

try {
    // Simular datos JSON que vendrían del frontend
    $json_data = json_encode([
        'lead_id' => 3,
        'type' => 'email',
        'subject' => 'Test Email Frontend',
        'description' => 'Este es un test de email desde el frontend',
        'activity_date' => date('Y-m-d H:i:s'),
        'created_by' => 1
    ]);
    
    echo "<h3>Datos JSON enviados:</h3>\n";
    echo "<pre>$json_data</pre>\n";
    
    // Simular que recibimos JSON
    $_SERVER['REQUEST_METHOD'] = 'POST';
    $_SERVER['CONTENT_TYPE'] = 'application/json';
    $_SERVER['HTTP_X_REQUESTED_WITH'] = 'XMLHttpRequest';
    
    // Guardar en php://input simulado
    $temp_file = tempnam(sys_get_temp_dir(), 'php_input_');
    file_put_contents($temp_file, $json_data);
    
    // Redirigir php://input a nuestro archivo temporal
    $original_input = file_get_contents('php://input');
    
    // Incluir el archivo add_note.php directamente
    ob_start();
    
    // Simular el contenido de php://input
    $GLOBALS['test_json_input'] = $json_data;
    
    // Modificar temporalmente file_get_contents para nuestro test
    echo "<h3>Ejecutando add_note.php...</h3>\n";
    
    // Ejecutar el script
    require_once 'add_note.php';
    
    $output = ob_get_clean();
    
    echo "<h3>Respuesta del servidor:</h3>\n";
    echo "<pre>" . htmlspecialchars($output) . "</pre>\n";
    
    // Limpiar archivo temporal
    unlink($temp_file);
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>\n";
}

echo "<hr>";
echo "<p><a href='debug_activities.php'>Ver todas las actividades</a></p>";
?>