<?php
// Diagnóstico del modal de citas
session_start();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Debug Modal Cita</title>
    <link rel="stylesheet" href="../../public/style.css">
</head>
<body>
    <div style="padding: 50px;">
        <h1>Debug Modal de Cita - Contexto Real</h1>
        
        <div style="background: #f8f9fa; padding: 20px; border-radius: 5px; margin-bottom: 20px;">
            <h3>Información del Sistema:</h3>
            <p><strong>Ruta actual:</strong> <?php echo __DIR__; ?></p>
            <p><strong>Sesión:</strong> <?php echo session_status() === PHP_SESSION_ACTIVE ? 'Activa' : 'Inactiva'; ?></p>
            <p><strong>Usuario:</strong> <?php echo $_SESSION['user_id'] ?? 'No definido'; ?></p>
        </div>
        
        <div style="margin: 20px 0;">
            <button onclick="testProfixCRM()" style="padding: 10px 20px; margin: 5px; background: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer;">
                Verificar ProfixCRM
            </button>
            
            <button onclick="testModalFromContext()" style="padding: 10px 20px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
                Probar Modal con Contexto
            </button>
            
            <button onclick="testDirectFunction()" style="padding: 10px 20px; margin: 5px; background: #dc3545; color: white; border: none; border-radius: 5px; cursor: pointer;">
                Función Directa
            </button>
        </div>
        
        <div id="debug-info" style="margin-top: 30px; padding: 20px; background: #e9ecef; border-radius: 5px;">
            <h3>Log de Debug:</h3>
            <div id="debug-content"></div>
        </div>
    </div>

    <!-- Solo cargar el script principal, no view_scripts.js para evitar errores -->
    <script src="../../public/script.js"></script>
    
    <script>
        function log(message) {
            const debugContent = document.getElementById('debug-content');
            const timestamp = new Date().toLocaleTimeString();
            debugContent.innerHTML += `<div style="margin: 5px 0; padding: 5px; background: white; border-radius: 3px;"><strong>${timestamp}:</strong> ${message}</div>`;
        }
        
        function testProfixCRM() {
            log('=== Verificando ProfixCRM ===');
            log('window existe: ' + (typeof window !== 'undefined'));
            log('window.ProfixCRM existe: ' + (typeof window.ProfixCRM !== 'undefined'));
            
            if (window.ProfixCRM) {
                log('Tipo de ProfixCRM: ' + typeof window.ProfixCRM);
                log('Funciones en ProfixCRM: ' + Object.keys(window.ProfixCRM).join(', '));
                log('openAppointmentAssistant existe: ' + (typeof window.ProfixCRM.openAppointmentAssistant === 'function'));
            } else {
                log('ERROR: ProfixCRM no está definido');
                log('Objetos globales disponibles: ' + Object.keys(window).filter(k => k.toLowerCase().includes('crm')).join(', '));
            }
        }
        
        function testModalFromContext() {
            log('=== Intentando abrir modal desde contexto ===');
            try {
                if (window.ProfixCRM && window.ProfixCRM.openAppointmentAssistant) {
                    log('Función disponible, abriendo modal...');
                    window.ProfixCRM.openAppointmentAssistant({
                        clientName: 'Lead de Prueba',
                        leadId: 999
                    });
                    log('Modal abierto exitosamente');
                } else {
                    log('ERROR: Función no disponible');
                    // Intentar ver si está en otro objeto
                    if (typeof openAppointmentAssistant === 'function') {
                        log('Función encontrada en scope global, intentando...');
                        openAppointmentAssistant({
                            clientName: 'Lead de Prueba',
                            leadId: 999
                        });
                        log('Modal abierto desde scope global');
                    }
                }
            } catch (error) {
                log('ERROR al abrir modal: ' + error.message);
                console.error('Error completo:', error);
            }
        }
        
        function testDirectFunction() {
            log('=== Buscando función directamente ===');
            try {
                // Verificar si existe de alguna forma
                const funciones = [];
                for (const key in window) {
                    if (typeof window[key] === 'function' && key.toLowerCase().includes('appointment')) {
                        funciones.push(key);
                    }
                }
                log('Funciones de appointment encontradas: ' + funciones.join(', '));
                
                // Verificar en objetos anidados
                if (window.ProfixCRM && window.ProfixCRM.openAppointmentAssistant) {
                    log('Encontrada en ProfixCRM.openAppointmentAssistant');
                } else if (typeof openAppointmentAssistant === 'function') {
                    log('Encontrada como openAppointmentAssistant global');
                } else {
                    log('No se encontró la función en ningún lugar conocido');
                }
            } catch (error) {
                log('ERROR en búsqueda: ' + error.message);
            }
        }
        
        // Verificación inicial
        window.addEventListener('load', function() {
            log('=== Página cargada ===');
            log('URL actual: ' + window.location.href);
            testProfixCRM();
        });
    </script>
</body>
</html>