<?php
/**
 * Seed de permisos de menú (menu.*.view) y asignación al rol Admin.
 * Ejecutar:
 *   php modules/database/seed_menu_permissions.php
 */

if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

$db = getDB();
$pdo = $db->getConnection();

$perms = [
  ['menu.dashboard.view','Ver Menú Dashboard','Permite ver el ítem de Dashboard en el menú','menu','dashboard.view',1],
  ['menu.leads.view','Ver Menú Leads','Permite ver el ítem de Leads en el menú','menu','leads.view',1],
  ['menu.activities.view','Ver Menú Actividades','Permite ver el ítem de Actividades en el menú','menu','activities.view',1],
  ['menu.reports.view','Ver Menú Reportes','Permite ver el ítem de Reportes en el menú','menu','reports.view',1],
  ['menu.users.view','Ver Menú Usuarios','Permite ver el ítem de Usuarios en el menú','menu','users.view',1],
  ['menu.roles.view','Ver Menú Roles','Permite ver el ítem de Roles y Permisos en el menú','menu','roles.view',1],
  ['menu.settings.view','Ver Menú Configuración','Permite ver el ítem de Configuración en el menú','menu','settings.view',1],
  ['menu.desks.view','Ver Menú Desks','Permite ver el ítem de Desks en el menú','menu','desks.view',1],
  ['menu.payments.view','Ver Menú Pagos','Permite ver el ítem de Métodos de Pago','menu','payments.view',1],
];

$stmt = $pdo->prepare("INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES (?,?,?,?,?,?)");
foreach ($perms as $p) { $stmt->execute($p); }

// Obtener id del rol admin
$roleAdminId = $pdo->query("SELECT id FROM roles WHERE name='admin' LIMIT 1")->fetchColumn();
if (!$roleAdminId) {
  $pdo->exec("INSERT INTO roles (name, display_name, description, is_system, is_active) VALUES ('admin','Administrador','Acceso completo',1,1)");
  $roleAdminId = $pdo->lastInsertId();
}

// Asignar TODOS los permisos al rol admin (incluye los de menú)
$pdo->exec("INSERT IGNORE INTO role_permissions (role_id, permission_id) SELECT " . (int)$roleAdminId . ", id FROM permissions");

echo "OK: permisos de menú insertados y asignados al rol Admin";
?>
