<?php
/**
 * Seed de permisos para Integraciones y Voiso.
 * Ejecutar:
 *   php modules/database/seed_integrations_permissions.php
 */
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

$db = getDB();
$pdo = $db->getConnection();

$perms = [
  // Visibilidad de módulo Integraciones
  ['integrations.view','Ver Integraciones','Acceder al módulo Integraciones','integrations','view',1],
  // Permiso de menú para sidebar
  ['menu.integrations.view','Ver Menú Integraciones','Ver Integraciones en el menú','menu','integrations.view',1],
  // Configuración de Voiso
  ['voiso.configure','Configurar Voiso','Guardar/editar credenciales y ajustes de Voiso','integrations','voiso.configure',1],
  // Acciones de Voiso
  ['voiso.click_to_call','Click-to-call Voiso','Permite realizar llamadas desde fichas','integrations','voiso.click_to_call',1],
];

$insPerm = $pdo->prepare("INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system, updated_at) VALUES (?,?,?,?,?,?,NOW())");
foreach ($perms as $p) { $insPerm->execute($p); }

// Asignar a rol admin si existe
$adminRoleId = null;
$stmt = $pdo->prepare("SELECT id FROM roles WHERE name = 'admin' LIMIT 1");
if ($stmt->execute() && ($row = $stmt->fetch())) { $adminRoleId = (int)$row['id']; }

if ($adminRoleId) {
  $getPermId = $pdo->prepare("SELECT id FROM permissions WHERE name = ?");
  $insRolePerm = $pdo->prepare("INSERT IGNORE INTO role_permissions (role_id, permission_id) VALUES (?, ?)");
  foreach ($perms as $p) {
    $getPermId->execute([$p[0]]);
    if ($pid = $getPermId->fetchColumn()) { $insRolePerm->execute([$adminRoleId, (int)$pid]); }
  }
}

echo "Permisos de Integraciones/Voiso creados y asignados a Admin.\n";
?>