<?php
/**
 * Seed de permisos del módulo Calendario y asignaciones a roles.
 * Ejecutar:
 *   php modules/database/seed_calendar_permissions.php
 */
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

$db = getDB();
$pdo = $db->getConnection();

$perms = [
  // Permisos del módulo Calendario
  ['calendar.view','Ver Calendario','Acceso al calendario','calendar','view',1],
  ['calendar.create','Crear Evento','Crear eventos en el calendario','calendar','create',1],
  ['calendar.edit','Editar Evento','Editar eventos propios','calendar','edit',1],
  ['calendar.delete','Eliminar Evento','Eliminar eventos propios','calendar','delete',1],
  ['calendar.view_all','Ver Calendarios de Todos','Ver calendarios de otros usuarios','calendar','view_all',1],
  ['calendar.edit_all','Editar Eventos de Todos','Editar eventos de otros usuarios','calendar','edit_all',1],

  // Permiso de menú
  ['menu.calendar.view','Ver Menú Calendario','Ver el ítem Calendario en el menú','menu','calendar.view',1],
];

$insPerm = $pdo->prepare("INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system, updated_at) VALUES (?,?,?,?,?,?,NOW())");
foreach ($perms as $p) { $insPerm->execute($p); }

function getRoleId(PDO $pdo, string $roleName): ?int {
  $stmt = $pdo->prepare("SELECT id FROM roles WHERE name = ? LIMIT 1");
  $stmt->execute([$roleName]);
  $id = $stmt->fetchColumn();
  return $id ? (int)$id : null;
}

function getPermId(PDO $pdo, string $permName): ?int {
  $stmt = $pdo->prepare("SELECT id FROM permissions WHERE name = ? LIMIT 1");
  $stmt->execute([$permName]);
  $id = $stmt->fetchColumn();
  return $id ? (int)$id : null;
}

function assignPermsToRole(PDO $pdo, int $roleId, array $permNames): int {
  $ins = $pdo->prepare("INSERT IGNORE INTO role_permissions (role_id, permission_id) VALUES (?, ?)");
  $count = 0;
  foreach ($permNames as $name) {
    $pid = getPermId($pdo, $name);
    if ($pid) { $ins->execute([$roleId, $pid]); $count++; }
  }
  return $count;
}

$roles = [
  'admin' => [
    'calendar.view','calendar.create','calendar.edit','calendar.delete','calendar.view_all','calendar.edit_all','menu.calendar.view'
  ],
  'manager' => [
    'calendar.view','calendar.create','calendar.edit','calendar.delete','calendar.view_all','calendar.edit_all','menu.calendar.view'
  ],
  'user' => [
    'calendar.view','menu.calendar.view'
  ],
  'sales_rep' => [
    'calendar.view','calendar.create','calendar.edit','menu.calendar.view'
  ],
  'marketing' => [
    'calendar.view','menu.calendar.view'
  ],
];

foreach ($roles as $roleName => $permNames) {
  $rid = getRoleId($pdo, $roleName);
  if ($rid) {
    $added = assignPermsToRole($pdo, $rid, $permNames);
    echo "Asignados {$added} permisos de Calendario al rol '{$roleName}'.\n";
  } else {
    echo "Rol '{$roleName}' no existe, omitido.\n";
  }
}

echo "Seed de permisos de Calendario completado.\n";
?>