<?php
/**
 * Utilidad: establecer/asegurar contraseña y permisos del usuario admin.
 * Uso CLI: php modules/database/admin_set_password.php
 * Uso Web (solo desarrollo): /modules/database/admin_set_password.php?token=dev
 */

// Preparar entorno
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

// En modo web, requiere token simple (evitar exposición accidental)
if (php_sapi_name() !== 'cli') {
    if (($_GET['token'] ?? '') !== 'dev') {
        http_response_code(403);
        echo 'Forbidden';
        exit;
    }
}

$db = getDB();
$pdo = $db->getConnection();

// Asegurar existencia del rol admin
$roleAdminId = $pdo->query("SELECT id FROM roles WHERE name='admin' LIMIT 1")->fetchColumn();
if (!$roleAdminId) {
    $stmt = $pdo->prepare("INSERT INTO roles (name, display_name, description, is_system, is_active) VALUES (?,?,?,?,?)");
    $stmt->execute(['admin','Administrador','Acceso completo',1,1]);
    $roleAdminId = $pdo->lastInsertId();
}

// Asegurar usuario admin y establecer contraseña 'passwoord'
$admin = $pdo->query("SELECT id FROM users WHERE username='admin' LIMIT 1")->fetchColumn();
$hash = password_hash('passwoord', PASSWORD_BCRYPT);

if ($admin) {
    $stmt = $pdo->prepare("UPDATE users SET password_hash = ?, status = 'active' WHERE id = ?");
    $stmt->execute([$hash, $admin]);
} else {
    $stmt = $pdo->prepare("INSERT INTO users (username, email, first_name, last_name, password_hash, status, created_at) VALUES (?,?,?,?,?,?,NOW())");
    $stmt->execute(['admin','admin@example.com','Admin','User',$hash,'active']);
    $admin = $pdo->lastInsertId();
}

// Asignar rol admin al usuario admin
$stmt = $pdo->prepare("INSERT IGNORE INTO user_roles (user_id, role_id, assigned_at) VALUES (?,?,NOW())");
$stmt->execute([(int)$admin, (int)$roleAdminId]);

// Asignar TODOS los permisos al rol admin (incluye nuevos)
$pdo->exec("INSERT IGNORE INTO role_permissions (role_id, permission_id) SELECT " . (int)$roleAdminId . ", id FROM permissions");

echo "OK: admin actualizado, rol admin con todos los permisos, contraseña establecida a 'passwoord'";
?>