<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(dirname(__DIR__)))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';
require_once BASE_PATH . '/modules/shared/helpers.php';

header('Content-Type: application/json');

$clientId = (int)($_GET['client_id'] ?? 0);
if ($clientId <= 0) { echo json_encode(['success'=>false,'accounts'=>[]]); exit; }

try {
  $db = Database::getInstance();
  $pdo = $db->getConnection();
  $stmt = $pdo->prepare('SELECT id, account_type, account_number, currency, balance FROM client_accounts WHERE client_id = ? AND status = "active" ORDER BY created_at ASC');
  $stmt->execute([$clientId]);
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
  echo json_encode(['success'=>true,'accounts'=>$rows]);
} catch (Throwable $e) {
  echo json_encode(['success'=>false,'accounts'=>[]]);
}
?>
