<?php
session_start();
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/modules/shared/helpers.php';

if (!isset($_SESSION['client_id'])) { header('Location: ' . module_url('client_portal/login.php')); exit(); }

$page_title = 'Configuración';
$module = 'settings';
$action = 'index';

ob_start();
?>
    <div class="section-header">
        <h2 class="section-title"><i class="fas fa-gear"></i> Configuración de Cuenta</h2>
    </div>
    <div id="settingsAlert" class="alert alert-success" style="display:none;margin-bottom:12px">Contraseña actualizada correctamente</div>

    <section class="settings-wrapper">
        <div class="settings-card hero">
            <div class="hero-icon"><i class="fas fa-shield-halved"></i></div>
            <div class="hero-content">
                <h3>Seguridad y Acceso</h3>
                <p>Protege tu cuenta con una contraseña fuerte. Recomendamos combinar mayúsculas, minúsculas, números y símbolos.</p>
            </div>
        </div>

        <div class="settings-card form">
            <h3>Cambiar Contraseña</h3>
            <form id="cpChangePwdForm" class="settings-form">
                <div class="form-row">
                    <label for="cpCurrentPassword">Contraseña actual</label>
                    <div class="input-wrap">
                        <i class="fas fa-lock"></i>
                        <input type="password" id="cpCurrentPassword" autocomplete="current-password" required>
                        <button type="button" class="toggle-visibility" data-target="cpCurrentPassword"><i class="fas fa-eye"></i></button>
                    </div>
                </div>
                <div class="form-row">
                    <label for="cpNewPassword">Nueva contraseña</label>
                    <div class="input-wrap">
                        <i class="fas fa-key"></i>
                        <input type="password" id="cpNewPassword" autocomplete="new-password" required>
                        <button type="button" class="toggle-visibility" data-target="cpNewPassword"><i class="fas fa-eye"></i></button>
                    </div>
                    <div class="pwd-meter" id="pwdMeter">
                        <span class="bar"></span>
                        <span class="label" id="pwdStrength">Fortaleza: —</span>
                    </div>
                </div>
                <div class="form-row">
                    <label for="cpConfirmPassword">Confirmar nueva contraseña</label>
                    <div class="input-wrap">
                        <i class="fas fa-check"></i>
                        <input type="password" id="cpConfirmPassword" autocomplete="new-password" required>
                        <button type="button" class="toggle-visibility" data-target="cpConfirmPassword"><i class="fas fa-eye"></i></button>
                    </div>
                </div>
                <div class="actions">
                    <button class="btn-primary" id="cpChangePwdBtn" type="button"><i class="fas fa-key"></i> Actualizar Contraseña</button>
                    <span id="cpPwdMsg" class="inline-msg" style="display:none"></span>
                </div>
            </form>
        </div>
    </section>

    <script>
    (function(){
        const btn = document.getElementById('cpChangePwdBtn');
        const toggleBtns = document.querySelectorAll('.toggle-visibility');
        const setMsg = function(t, ok){ const el = document.getElementById('cpPwdMsg'); if(!el) return; el.textContent = t; el.style.display='inline-block'; el.className = 'inline-msg ' + (ok ? 'ok' : 'err'); };
        const strengthEl = document.getElementById('pwdStrength');
        const barEl = document.querySelector('#pwdMeter .bar');
        const evaluate = function(v){ let s=0; if (v.length>=6) s++; if (/[A-Z]/.test(v)) s++; if (/[a-z]/.test(v)) s++; if (/\d/.test(v)) s++; if (/[^A-Za-z0-9]/.test(v)) s++; const labels=['Muy débil','Débil','Media','Buena','Fuerte']; const idx=Math.max(0,Math.min(labels.length-1,s-1)); strengthEl.textContent='Fortaleza: '+labels[idx]; const widths=['20%','35%','55%','75%','100%']; barEl.style.width=widths[idx]; barEl.className='bar level-'+idx; };
        const np = document.getElementById('cpNewPassword'); if (np) np.addEventListener('input', function(){ evaluate(this.value||''); });
        toggleBtns.forEach(function(tb){ tb.addEventListener('click', function(){ const id=this.getAttribute('data-target'); const inp=document.getElementById(id); if(!inp) return; const t=inp.getAttribute('type')==='password'?'text':'password'; inp.setAttribute('type',t); }); });
        if (btn) btn.addEventListener('click', function(){
            const cur = document.getElementById('cpCurrentPassword')?.value || '';
            const nw = document.getElementById('cpNewPassword')?.value || '';
            const cf = document.getElementById('cpConfirmPassword')?.value || '';
            if (!cur || !nw || !cf) { setMsg('Completa todos los campos'); return; }
            if (nw.length < 6) { setMsg('La nueva contraseña debe tener al menos 6 caracteres'); return; }
            if (nw !== cf) { setMsg('Las contraseñas no coinciden'); return; }
            fetch('<?php echo module_url('client_portal/api/change_password.php'); ?>', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: new URLSearchParams({ current_password: cur, new_password: nw, confirm_password: cf }).toString() })
                .then(function(r){ return r.json(); })
                .then(function(j){ if (j && j.success) { setMsg('Contraseña actualizada', true); var sa=document.getElementById('settingsAlert'); if(sa){ sa.style.display='block'; setTimeout(function(){ sa.style.display='none'; }, 3000); } try { document.getElementById('cpCurrentPassword').value=''; document.getElementById('cpNewPassword').value=''; document.getElementById('cpConfirmPassword').value=''; strengthEl.textContent='Fortaleza: —'; barEl.style.width='0%'; barEl.className='bar'; } catch(_) {} } else { setMsg(j.message || 'Error actualizando contraseña'); } })
                .catch(function(){ setMsg('Error de conexión'); });
        });
    })();
    </script>
    <style>
      .settings-wrapper{display:grid;grid-template-columns:1.2fr 1fr;gap:18px}
      .settings-card{background:#fff;border:1px solid #e5e7eb;border-radius:16px;box-shadow:0 12px 28px rgba(0,0,0,.06);padding:18px}
      .settings-card.hero{display:flex;align-items:center;gap:16px;background:linear-gradient(180deg,#ffffff,#f6f8fb)}
      .hero-icon{width:56px;height:56px;border-radius:14px;background:#e0f2fe;color:#0369a1;display:flex;align-items:center;justify-content:center;font-size:22px}
      .settings-card.form h3{margin-bottom:10px}
      .settings-form{display:grid;gap:12px}
      .form-row label{font-weight:700;margin-bottom:6px}
      .input-wrap{position:relative;display:flex;align-items:center;background:#f8fafc;border:1px solid #e5e7eb;border-radius:10px;padding:8px 10px}
      .input-wrap i{color:#6b7280;margin-right:8px}
      .input-wrap input{flex:1;border:0;background:transparent;outline:none}
      .toggle-visibility{border:0;background:transparent;color:#6b7280;cursor:pointer}
      .pwd-meter{display:flex;align-items:center;gap:10px;margin-top:8px}
      .pwd-meter .bar{display:block;height:8px;width:0;border-radius:999px;background:#fee2e2;transition:width .2s ease}
      .pwd-meter .bar.level-1{background:#fde68a}
      .pwd-meter .bar.level-2{background:#facc15}
      .pwd-meter .bar.level-3{background:#86efac}
      .pwd-meter .bar.level-4{background:#22c55e}
      .pwd-meter .label{font-size:12px;color:#374151}
      .actions{display:flex;align-items:center;gap:12px;margin-top:6px}
      .btn-primary{background:linear-gradient(135deg,#2ea6ff,#1b7bd3);border:1px solid rgba(46,166,255,.35);color:#fff;border-radius:10px;padding:10px 14px;cursor:pointer}
      .btn-primary i{margin-right:6px}
      .inline-msg{font-size:12px}
      .inline-msg.ok{color:#16a34a}
      .inline-msg.err{color:#d93025}
      @media (max-width: 900px){ .settings-wrapper{grid-template-columns:1fr} }
    </style>
<?php
$content = ob_get_clean();
include __DIR__ . '/layout.php';
?>
