<?php
session_start();
// Definir BASE_PATH y helpers para rutas dinámicas
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/modules/shared/helpers.php';

// Destruir toda la sesión del cliente
$_SESSION = [];
if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
}
session_destroy();

// Redirigir al Trader Room (login del portal de cliente)
$redirectParam = isset($_GET['redirect']) ? $_GET['redirect'] : '/modules/client_portal/dashboard.php';
$loginUrl = module_url('client_portal/login.php') . '?redirect=' . urlencode($redirectParam) . '&message=logged_out';
header('Location: ' . $loginUrl);
exit;
?>
