<?php
?><!doctype html>
<html lang="es">
  <head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>Checkout</title>
    <style>
      :root{ --bg:#0f1320; --card:#171c2b; --text:#e5e7eb; --muted:#9aa0aa; --primary:#2ea6ff; --border:#2a3142 }
      *{ box-sizing:border-box }
      html,body{ height:100% }
      body{ margin:0; background:linear-gradient(180deg,#0f1320,#0c111b); color:var(--text); font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,sans-serif }
      .shell{ max-width:1400px; margin:0 auto; padding:24px }
      .card{ background:var(--card); border:1px solid var(--border); border-radius:16px; box-shadow:0 8px 20px rgba(0,0,0,.35) }
      .card-body{ padding:18px }
      .page-title{ display:flex; align-items:center; gap:10px; font-size:22px; margin:0 }
      .page-subtitle{ color:var(--muted); margin:4px 0 12px }
      .filters-grid{ display:grid; grid-template-columns:repeat(4,minmax(0,1fr)); gap:12px }
      .form-input,.form-select{ padding:10px 12px; border:1px solid #2a3142; border-radius:10px; background:#0c111b; color:#e5e7eb }
      .methods-grid{ margin-top:10px }
      .method-group-title{ display:flex; align-items:center; gap:8px; color:var(--muted); font-weight:700; margin-bottom:8px }
      .method-tiles{ display:grid; grid-template-columns:repeat(3,minmax(0,1fr)); gap:10px }
      .method-chip{ display:flex; align-items:center; justify-content:space-between; gap:10px; background:rgba(255,255,255,.06); border:1px solid rgba(255,255,255,.12); border-radius:10px; padding:10px 12px }
      .method-chip:hover{ border-color:var(--primary); box-shadow:0 0 0 2px rgba(46,166,255,.25) }
      .method-chip.selected{ border-color:var(--primary); box-shadow:0 0 0 2px rgba(46,166,255,.35) }
      .chip-left{ display:flex; align-items:center; gap:10px }
      .method-logo{ width:90px; height:26px; object-fit:contain }
      .method-name{ font-weight:700; font-size:13px }
      .badge{ display:inline-block; padding:2px 8px; border-radius:999px; background:#0b2136; color:#9ecbff; font-size:11px }
      .method-limits{ display:flex; align-items:center; gap:14px; color:#9aa0aa; font-size:12px }
      .limit-icon{ display:inline-block; color:#7bb6ff; margin-right:4px; font-weight:700 }
      .checkout-actions{ display:flex; gap:10px; margin-top:16px }
      .btn{ border:0; border-radius:10px; padding:10px 14px; cursor:pointer }
      .btn-primary{ background:linear-gradient(180deg,#2ea6ff,#1b7bd3); color:white }
      .alert{ margin-top:10px; padding:10px 12px; border-radius:10px }
      .alert-success{ background:#12331f; color:#a8f0c7 }
      .alert-error{ background:#2b1717; color:#f5a6a6 }
      @media (max-width: 1024px){ .filters-grid{ grid-template-columns:repeat(2,minmax(0,1fr)) } .method-tiles{ grid-template-columns:repeat(2,minmax(0,1fr)) } }
      @media (max-width: 640px){ .filters-grid{ grid-template-columns:1fr } .method-tiles{ grid-template-columns:1fr } .shell{ padding:14px } }
    </style>
  </head>
  <body>
    <div class="shell">
      <?php echo $content; ?>
    </div>
  </body>
</html>
