<?php
session_start();
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(dirname(__DIR__)))); }
require_once BASE_PATH . '/database/connection.php';
require_once BASE_PATH . '/modules/shared/helpers.php';
require_once BASE_PATH . '/api/shared/ApiLoader.php';
function b64u_decode($s){ $s=strtr($s,'-_','+/'); $p=strlen($s)%4; if($p){ $s.=str_repeat('=',4-$p); } return base64_decode($s); }
$clientLogged = isset($_SESSION['client_id']) && !empty($_SESSION['client_id']);
$userLogged = isLoggedIn();
$sso = isset($_GET['sso']) ? $_GET['sso'] : null;
if (!$clientLogged && $sso) {
  $raw = b64u_decode($sso);
  $parts = explode('|', (string)$raw);
  if (count($parts)===4) {
    $cid = (int)$parts[0];
    $acc = (string)$parts[1];
    $exp = (int)$parts[2];
    $sig = (string)$parts[3];
    $calc = hash_hmac('sha256', ($parts[0].'|'.$parts[1].'|'.$parts[2]), APP_SECRET);
    if (hash_equals($calc, $sig) && $exp>=time() && $cid>0) {
      $_SESSION['client_id'] = $cid;
      $_SESSION['account_number'] = $acc;
      $clientLogged = true;
    }
  }
}
if (!$clientLogged && !$userLogged) { header('Location: ' . module_url('client_portal/login.php')); exit; }
$page_title = 'Checkout Key2Pay';
$active = 'checkout_key2pay';
ob_start();
?>
<div class="checkout-page">
  <h3 class="page-title">Checkout de Pagos</h3>
  <p class="page-subtitle">Métodos Key2Pay y filtros en tiempo real</p>
  <div class="card">
    <div class="card-body">
      <div class="filters-grid">
        <input id="amountInput" class="form-input amount-fixed" type="number" step="0.01" min="1" placeholder="Monto" readonly />
        <input id="searchInput" class="form-input" placeholder="Buscar método" />
        <select id="channelSelect" class="form-select"><option value="">Todos los canales</option></select>
        <select id="countrySelect" class="form-select"><option value="">Todos los países</option></select>
        <select id="currencySelect" class="form-select"><option value="">Todas las divisas</option></select>
        <select id="sortSelect" class="form-select"><option value="relevance">Relevancia</option><option value="name">Nombre (A-Z)</option><option value="min">Mínimo (asc)</option></select>
        <button id="clearFiltersBtn" class="btn btn-secondary" type="button">Limpiar filtros</button>
        <button id="applyFiltersBtn" class="btn btn-primary" type="button">Aplicar filtros</button>
      </div>
      
      <div id="methodsContainer" class="methods-grid"></div>
      <div id="statusBox" class="alert" style="display:none"></div>
      <div class="checkout-actions"><button id="startCheckoutBtn" class="btn btn-primary">Depositar</button></div>
    </div>
  </div>
</div>
<script>
const INIT_METHODS = []
let METHODS = []
let FILTERS = { search:'', channel:'', country:'', currency:'' }
let CHANNELS_ALL = []
let COUNTRIES_ALL = []
let CURRENCIES_ALL = []
let SORT_BY = 'relevance'
let SELECTED = null
let PER_PAGE = 25
let CURRENT_PAGE = 1
const BASE_PFX = (location.pathname.indexOf('/simple_crm/') !== -1) ? '/simple_crm' : ''
function qs(id){ return document.getElementById(id) }
function fetchMethods(showSk = true){
  const params = new URLSearchParams()
  if (FILTERS.channel) params.set('channel', FILTERS.channel)
  if (FILTERS.country) params.set('country', FILTERS.country)
  if (FILTERS.currency) params.set('currency', FILTERS.currency)
  const cont = qs('methodsContainer'); if (cont && showSk) cont.innerHTML = skeletonGrid()
  const qsStr = params.toString()?('&'+params.toString()):''
  const origin = location.origin
  const candidates = [
    origin + BASE_PFX + '/modules/checkout/actions.php?action=list_key2pay_methods' + qsStr,
    origin + '/simple_crm/modules/checkout/actions.php?action=list_key2pay_methods' + qsStr,
    origin + '/modules/checkout/actions.php?action=list_key2pay_methods' + qsStr,
    origin + BASE_PFX + '/modules/checkout/key2pay/actions.php?action=list_key2pay_methods' + qsStr,
    origin + '/simple_crm/modules/checkout/key2pay/actions.php?action=list_key2pay_methods' + qsStr,
    origin + '/modules/checkout/key2pay/actions.php?action=list_key2pay_methods' + qsStr
  ]
  const tryFetch = async (urls) => { for (let i=0;i<urls.length;i++){ try { const res = await fetch(urls[i], { method:'GET', credentials:'same-origin', headers:{'Accept':'application/json'}, cache:'no-store' }); if (!res.ok) continue; const data = await res.json(); if (data && (Array.isArray(data.items) || data.success)) return data } catch(e){} } throw new Error('fetch_failed') }
  return tryFetch(candidates)
    .then(d=>{ METHODS = Array.isArray(d.items)? d.items: []; updateChannelOptions(METHODS); updateCountryOptions(METHODS); updateCurrencyOptions(METHODS); renderMethods() })
    .catch((e)=>{ if(cont) cont.innerHTML = '<div class="alert alert-error">Error cargando métodos</div>'; const status = qs('statusBox'); if(status){ status.className='alert alert-error'; status.textContent='No se pudo obtener métodos de Key2Pay'; status.style.display='block' } })
}
function updateChannelOptions(items){ const sel = qs('channelSelect'); if(!sel) return; const chs = (items||[]).map(m => String(m.channel||'').toUpperCase()).filter(Boolean); let uniq = Array.from(new Set(chs)); if (!uniq.length) uniq = ['ONLINE','CASH']; CHANNELS_ALL = uniq; const counts = {}; chs.forEach(c => { counts[c] = (counts[c]||0)+1 }); const cur = FILTERS.channel || ''; sel.innerHTML = '<option value="">Todos los canales</option>' + uniq.map(ch => `<option value="${ch}" ${cur===ch?'selected':''}>${ch} (${counts[ch]||0})</option>`).join('') }
function updateCountryOptions(items){ const sel = qs('countrySelect'); if(!sel) return; let uniq = Array.from(new Set((items||[]).map(m => String(m.country||'').toUpperCase()).filter(Boolean))).sort(); if (!uniq.length) uniq = ['MX','CO','PE','BR','AR','EC','US']; const names = {US:'Estados Unidos',MX:'México',AR:'Argentina',BR:'Brasil',CL:'Chile',CO:'Colombia',PE:'Perú',EC:'Ecuador',UY:'Uruguay',BO:'Bolivia',CR:'Costa Rica',PA:'Panamá'}; const cur = (FILTERS.country||'').toUpperCase(); sel.innerHTML = '<option value="">Todos los países</option>' + uniq.map(code => `<option value="${code}" ${cur===code?'selected':''}>${names[code]||code}</option>`).join(''); COUNTRIES_ALL = uniq; }
function updateCurrencyOptions(items){ const sel = qs('currencySelect'); if(!sel) return; const set = new Set(); (items||[]).forEach(m => { (m.currencies||[]).forEach(c => { const v = String(c||'').toUpperCase(); if(v) set.add(v) }); (m.currencyLimits||[]).forEach(cl => { const v = String(cl.code||'').toUpperCase(); if(v) set.add(v) }) }); const uniq = Array.from(set).sort(); CURRENCIES_ALL = uniq; const cur = FILTERS.currency || ''; sel.innerHTML = '<option value="">Todas las divisas</option>' + uniq.map(code => `<option value="${code}" ${cur===code?'selected':''}>${code}</option>`).join('') }
function countryName(code){ const m={US:'Estados Unidos',MX:'México',AR:'Argentina',BR:'Brasil',CL:'Chile',CO:'Colombia',PE:'Perú',EC:'Ecuador',UY:'Uruguay',BO:'Bolivia',CR:'Costa Rica',PA:'Panamá'}; const c=String(code||'').toUpperCase(); return m[c]||c }
function renderQuickFilters(){ }
function applyFilters(arr){ const t = (FILTERS.search||'').trim().toLowerCase(); const matches = (m) => { const nameOk = !t || String(m.name||'').toLowerCase().includes(t) || String(m.country||'').toLowerCase().includes(t); const chOk = !FILTERS.channel || (String(m.channel||'').trim().toUpperCase() === FILTERS.channel); const coOk = !FILTERS.country || (String(m.country||'').trim().toUpperCase() === FILTERS.country); const cuOk = !FILTERS.currency || ((m.currencies||[]).map(x=>String(x).toUpperCase()).includes(FILTERS.currency)); return nameOk && chOk && coOk && cuOk }; let out = (arr||[]).filter(matches); if (SORT_BY === 'name') out = out.slice().sort((a,b)=>String(a.name||'').localeCompare(String(b.name||''))); if (SORT_BY === 'min') out = out.slice().sort((a,b)=>{ const la = (a.currencyLimits||[]).find(x=>String(x.code||'').toUpperCase()===(FILTERS.currency||'').toUpperCase()) || (a.currencyLimits||[])[0] || {}; const lb = (b.currencyLimits||[]).find(x=>String(x.code||'').toUpperCase()===(FILTERS.currency||'').toUpperCase()) || (b.currencyLimits||[])[0] || {}; return (la.min??Infinity) - (lb.min??Infinity) }); return out }
function getFavs(){ try{ const s = localStorage.getItem('k2pay_favs'); return s? JSON.parse(s): [] }catch(_){ return [] } }
function setFavs(arr){ try{ localStorage.setItem('k2pay_favs', JSON.stringify(arr||[])) }catch(_){} }
function sortByFav(arr){ const favs = getFavs(); const set = new Set(favs.map(String)); return (arr||[]).slice().sort((a,b)=>{ const af=set.has(String(a.uid)); const bf=set.has(String(b.uid)); if (af&&!bf) return -1; if (!af&&bf) return 1; return 0 }) }
function renderMethods(){ const cont = qs('methodsContainer'); if (!cont) return; let arr = applyFilters(METHODS); if (!arr.length){ cont.innerHTML = '<div class="alert alert-info">Sin métodos disponibles</div>'; return } arr = sortByFav(arr); const total = arr.length; const pages = Math.max(1, Math.ceil(total / PER_PAGE)); if (CURRENT_PAGE < 1) CURRENT_PAGE = 1; if (CURRENT_PAGE > pages) CURRENT_PAGE = pages; const start = (CURRENT_PAGE - 1) * PER_PAGE; const pageItems = arr.slice(start, start + PER_PAGE); const favs = getFavs(); const html = pageItems.map(m => { const curLimits = Array.isArray(m.currencyLimits)? m.currencyLimits: []; const targetCur = FILTERS.currency || ((m.currencies||[])[0] || ''); const findCur = curLimits.find(x => String(x.code||'').toUpperCase() === String(targetCur).toUpperCase()) || {}; const min = (typeof findCur.min !== 'undefined' && findCur.min !== null) ? findCur.min : null; const max = (typeof findCur.max !== 'undefined' && findCur.max !== null) ? findCur.max : null; const checked = SELECTED && SELECTED.uid === m.uid ? 'selected' : ''; const badge = targetCur ? `<span class=\"badge badge-info\">${String(targetCur).toUpperCase()}</span>` : ''; const logo = m.imageUrl?`<img class=\"method-logo\" src=\"${m.imageUrl}\" alt=\"${m.name}\">`:''; const titleRow = `<div class=\"method-title-row\"><span class=\"method-name\" title=\"${m.name}\">${m.name}</span>${badge}</div>`; const limits = `<div class=\"method-limits\">${min!==null?`<span><span class=\"limit-icon\">↓</span> Min ${min}</span>`:''}${max!==null?`<span><span class=\"limit-icon\">↑</span> Max ${max}</span>`:''}</div>`; const channel = String(m.channel||'').toUpperCase(); const ribbon = channel?`<div class=\"card-ribbon ${channel.toLowerCase()}\">${channel}</div>`:''; const isFav = favs.includes(String(m.uid)); const favCls = isFav? 'fav-btn active': 'fav-btn'; return `<label class=\"method-card ${checked}\" data-uid=\"${m.uid}\">${ribbon}<input type=\"radio\" name=\"methodSel\" class=\"method-input\"><div class=\"card-top\">${logo}<button class=\"${favCls}\" type=\"button\" data-uid=\"${m.uid}\" title=\"Favorito\">★</button></div><div class=\"card-body\">${titleRow}${limits}</div></label>` }).join(''); const pager = `<div class=\"pager\">${pages>1?(`<button class=\"btn btn-outline\" id=\"pgPrev\">◀</button><span class=\"page\">${CURRENT_PAGE} / ${pages}</span><button class=\"btn btn-outline\" id=\"pgNext\">▶</button>`):''}</div>`; cont.innerHTML = `<div class=\"method-group\"><div class=\"method-group-title\"><span class=\"icon-list\">●</span><span>Métodos</span></div><div class=\"method-tiles\">${html}</div>${pager}</div>`; cont.querySelectorAll('.method-card').forEach(el=>{ el.addEventListener('click', ()=>{ cont.querySelectorAll('.method-card').forEach(x=>x.classList.remove('selected')); el.classList.add('selected'); const uid = el.getAttribute('data-uid'); SELECTED = METHODS.find(x => String(x.uid) === String(uid)) || null }) }); cont.querySelectorAll('.fav-btn').forEach(btn=>{ btn.addEventListener('click', (e)=>{ e.stopPropagation(); const uid = btn.getAttribute('data-uid'); let favs = getFavs(); if (favs.includes(uid)) { favs = favs.filter(x=>x!==uid); btn.classList.remove('active'); } else { favs.push(uid); btn.classList.add('active'); } setFavs(favs); renderMethods(); }) }); const prev = document.getElementById('pgPrev'); const next = document.getElementById('pgNext'); if (prev) prev.addEventListener('click', ()=>{ CURRENT_PAGE = Math.max(1, CURRENT_PAGE - 1); renderMethods() }); if (next) next.addEventListener('click', ()=>{ CURRENT_PAGE = CURRENT_PAGE + 1; renderMethods() }) }
function onFilter(){ FILTERS.search = String(qs('searchInput').value||''); FILTERS.channel = String(qs('channelSelect').value||'').trim().toUpperCase(); FILTERS.currency = String(qs('currencySelect').value||'').trim().toUpperCase(); SORT_BY = qs('sortSelect').value; CURRENT_PAGE = 1; fetchMethods(true) }
function clearFilters(){ FILTERS = { search:'', channel:'', country:'', currency:'' }; CURRENT_PAGE = 1; const ids=['searchInput','channelSelect','currencySelect','sortSelect']; ids.forEach(id=>{ const el=qs(id); if (!el) return; if (id==='searchInput') el.value=''; else if (id==='sortSelect') el.value='relevance'; else el.value=''; }); fetchMethods(true) }
function applyFiltersNow(){ FILTERS.search = String(qs('searchInput').value||''); FILTERS.channel = String(qs('channelSelect').value||'').trim().toUpperCase(); FILTERS.currency = String(qs('currencySelect').value||'').trim().toUpperCase(); SORT_BY = qs('sortSelect').value; CURRENT_PAGE = 1; fetchMethods(true) }
document.addEventListener('DOMContentLoaded', ()=>{
  ['searchInput','channelSelect','currencySelect','sortSelect'].forEach(id=>{ qs(id).addEventListener(id==='searchInput'?'input':'change', onFilter) })
  const clr = qs('clearFiltersBtn'); if (clr) clr.addEventListener('click', clearFilters)
  const applyBtn = qs('applyFiltersBtn'); if (applyBtn) applyBtn.addEventListener('click', applyFiltersNow)
  const status = qs('statusBox'); if (status) { status.style.display='none' }
  qs('startCheckoutBtn').addEventListener('click', async ()=>{
    const status = qs('statusBox'); status.style.display='none'
    const amt = parseFloat(qs('amountInput').value||'0')
    if (!SELECTED){ status.className='alert alert-error'; status.textContent='Selecciona un método'; status.style.display='block'; return }
    if (!Number.isFinite(amt) || amt<=0){ status.className='alert alert-error'; status.textContent='Monto inválido'; status.style.display='block'; return }
    try{
      const params = new URLSearchParams()
      const currency = FILTERS.currency || (Array.isArray(SELECTED.currencies)? (SELECTED.currencies[0]||'USD') : 'USD')
      function makeOrderId(n){ const chars='ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; let s=''; for(let i=0;i<n;i++){ s+=chars[Math.floor(Math.random()*chars.length)] } return s }
      params.set('paymentMethodId', String(SELECTED.uid||''))
      params.set('channel', String((SELECTED.channel||'').toUpperCase()||'ONLINE'))
      params.set('currency', currency)
      params.set('amount', String(Math.round(amt*100)))
      params.set('order_id', makeOrderId(20))
      params.set('language', 'ES')
      const fn = (qs('firstNameInput')||{}).value||''
      const ln = (qs('lastNameInput')||{}).value||''
      if (fn) params.set('first_name', fn)
      if (ln) params.set('last_name', ln)
      if (window.CP_EMAIL) params.set('email', String(window.CP_EMAIL))
      if (window.CP_PHONE) params.set('phone', String(window.CP_PHONE))
      if (window.CP_MOBILE) params.set('mobile', String(window.CP_MOBILE))
      if (window.CP_COUNTRY) params.set('country', String(window.CP_COUNTRY))
      if (window.CP_CLIENT_ID) params.set('client_id', String(window.CP_CLIENT_ID))
      if (window.CP_ACCOUNT_NUMBER) params.set('account_number', String(window.CP_ACCOUNT_NUMBER))
      if (window.CP_TOKEN_OVERRIDE) params.set('token_override', String(window.CP_TOKEN_OVERRIDE))
      if (window.CP_NOTIFICATION_URL) params.set('notification_url', String(window.CP_NOTIFICATION_URL))
      const r = await fetch(BASE_PFX + '/modules/checkout/key2pay/actions.php?action=create_key2pay_payment_raw', { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body: params.toString() })
      const d = await r.json()
      if (d && d.success){
        const url = d.redirect_url || d.checkout_url || (d.json && (d.json.redirect_url || d.json.checkout_url || d.json.payment_link || d.json.checkoutUrl || d.json.paymentPageUrl || d.json.paymentFormUrl))
        if (url){ window.open(url, '_blank', 'noopener'); status.className='alert alert-success'; status.textContent='Checkout iniciado'; status.style.display='block' } else { status.className='alert alert-error'; status.textContent='No se recibió URL de checkout'; status.style.display='block' }
      } else { status.className='alert alert-error'; status.textContent = (d && d.http_code ? ('HTTP '+d.http_code+' · ') : '') + (d && d.message ? d.message : 'Error iniciando checkout'); status.style.display='block' }
    }catch(e){ status.className='alert alert-error'; status.textContent='Error de conexión'; status.style.display='block' }
  })
  const qp = new URLSearchParams(location.search)
  const amtQ = qp.get('amount')
  const curQ = qp.get('currency')
  const clientQ = qp.get('client_id')
  const accQ = qp.get('account_number')
  const firstQ = qp.get('first_name')
  const lastQ = qp.get('last_name')
  const emailQ = qp.get('email')
  const phoneQ = qp.get('phone')
  const mobileQ = qp.get('mobile')
  const countryQ = qp.get('country')
  const tokenQ = qp.get('token')
  const ipnQ = qp.get('notification_url')
  if (amtQ) { const a = parseFloat(amtQ); if (Number.isFinite(a) && a>0) { qs('amountInput').value = String(a) } }
  if (curQ) { FILTERS.currency = String(curQ).toUpperCase(); if (qs('currencySelect')) qs('currencySelect').value = FILTERS.currency }
  window.CP_CLIENT_ID = clientQ ? parseInt(clientQ,10) : null
  window.CP_ACCOUNT_NUMBER = accQ || null
  if (firstQ && qs('firstNameInput')) qs('firstNameInput').value = firstQ
  if (lastQ && qs('lastNameInput')) qs('lastNameInput').value = lastQ
  window.CP_EMAIL = emailQ || null
  window.CP_PHONE = phoneQ || null
  window.CP_MOBILE = mobileQ || null
  window.CP_COUNTRY = countryQ ? String(countryQ).toUpperCase() : null
  window.CP_TOKEN_OVERRIDE = tokenQ || null
  window.CP_NOTIFICATION_URL = ipnQ || null
  if (!FILTERS.channel) { FILTERS.channel = 'ONLINE'; if (qs('channelSelect')) qs('channelSelect').value = 'ONLINE' }
  if (!FILTERS.currency) { FILTERS.currency = (curQ ? String(curQ).toUpperCase() : 'USD'); if (qs('currencySelect')) qs('currencySelect').value = FILTERS.currency }
  if (!FILTERS.country && window.CP_COUNTRY) { FILTERS.country = window.CP_COUNTRY; }
  fetchMethods(true)
})
function flagEmoji(code){ const c = String(code||'').toUpperCase(); if(c.length!==2) return ''; const base = 127397; return String.fromCodePoint(c.charCodeAt(0)+base) + String.fromCodePoint(c.charCodeAt(1)+base) }
function skeletonGrid(){ return '<div class="skeleton-grid">'+Array.from({length:6}).map(()=>'<div class="sk-card"><div class="sk-logo"></div><div class="sk-line"></div><div class="sk-line small"></div></div>').join('')+'</div>' }
</script>
<style>
.checkout-page .filters-grid{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:10px;margin-bottom:10px}
.amount-fixed{font-weight:700}
.methods-grid{margin-top:8px}
.checkout-page .card{width:100%}
.checkout-page .card .card-body{width:100%}
#methodsContainer{width:100%}
.form-input,.form-select{padding:10px;border:1px solid #e5e7eb;border-radius:10px;background:#fff;color:#111}
.amount-fixed{font-weight:700}
.form-input::placeholder{color:#777}
.form-select option{color:#111}
.method-name{font-weight:700;font-size:13px}
.method-card{display:flex;flex-direction:column;gap:10px;background:linear-gradient(180deg, rgba(255,255,255,.08), rgba(255,255,255,.04));border:1px solid rgba(255,255,255,.14);border-radius:16px;padding:16px}
.method-card{position:relative; padding-top:56px}
.card-ribbon{position:absolute;left:0;right:0;top:0;padding:6px 12px;border-radius:16px 16px 0 0;color:#fff;font-size:12px;font-weight:700;letter-spacing:.02em;text-align:center;height:34px;line-height:22px}
.card-ribbon.online{background:linear-gradient(180deg,#2ea6ff,#1b7bd3)}
.card-ribbon.cash{background:linear-gradient(180deg,#10b981,#058e63)}
.method-card{box-sizing:border-box; overflow:hidden}
.method-card:hover{border-color:#7bb6ff;box-shadow:0 0 0 2px rgba(46,166,255,.25)}
.method-card.selected{border-color:#2ea6ff;box-shadow:0 0 0 2px rgba(46,166,255,.35)}
.method-card input{display:none}
.card-top{display:flex;align-items:center;justify-content:center}
.method-card .card-top,.method-card .card-body{width:100%}
.fav-btn{position:absolute; right:14px; bottom:14px; background:transparent; border:0; color:#9aa3af; font-size:26px; line-height:1; cursor:pointer}
.fav-btn.active{color:#f59e0b}
.method-tiles{display:grid;grid-template-columns:repeat(5,minmax(0,1fr));gap:12px}
.method-logo{width:180px;height:48px;object-fit:contain;margin-top:14px}
.method-card .card-top{margin-top:12px}
.method-title-row{display:flex;align-items:center;justify-content:space-between;gap:8px}
.method-name{font-weight:700;font-size:14px;max-width:70%;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
.badge{display:inline-block;padding:2px 8px;border-radius:999px;background:#0b2136;color:#9ecbff;font-size:11px}
.method-limits{display:flex;align-items:center;gap:16px;color:#6c757d;font-size:12px;flex-wrap:nowrap;white-space:nowrap}
.method-limits span{white-space:nowrap}
.limit-icon{display:inline-block;color:#7bb6ff;margin-right:4px;font-weight:700}
.icon-list{color:#7bb6ff;margin-right:6px}
.pager{display:flex;justify-content:center;align-items:center;gap:10px;margin-top:16px}
.pager .btn.btn-outline{background:transparent;border:1px solid #ffffff;border-radius:10px;padding:6px 10px;color:#ffffff}
.btn.btn-secondary{background:#fff;border:1px solid #e5e7eb;border-radius:10px;padding:10px 12px;color:#111}
.pager .page{color:#ffffff;font-weight:700}
.method-tiles{display:grid;grid-template-columns:repeat(5,minmax(0,1fr));gap:12px}
@media (max-width: 1280px){.method-tiles{grid-template-columns:repeat(4,minmax(0,1fr))}}
@media (max-width: 1024px){.method-tiles{grid-template-columns:repeat(3,minmax(0,1fr))}}
@media (max-width: 768px){.method-tiles{grid-template-columns:repeat(2,minmax(0,1fr))}}
@media (max-width: 480px){.method-tiles{grid-template-columns:1fr}}
.quick-filters{display:flex;gap:16px;flex-wrap:wrap}
.chip-group{display:flex;gap:8px;align-items:center}
.chip-group>span{color:#6c757d;font-weight:700}
.chip{border:1px solid #e5e7eb;background:#fff;border-radius:999px;padding:6px 10px;font-size:12px;cursor:pointer}
.chip-scroll{flex-wrap:wrap;row-gap:8px}
.skeleton-grid{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:10px}
.sk-card{border:1px solid #eceff4;border-radius:10px;padding:10px;background:#fafafa}
.sk-logo{height:18px;background:linear-gradient(90deg,#eee,#f7f7f7,#eee);border-radius:6px;margin-bottom:8px}
.sk-line{height:12px;background:linear-gradient(90deg,#eee,#f7f7f7,#eee);border-radius:6px;margin-bottom:6px}
.sk-line.small{width:60%}
.debug-box{margin-top:12px; background:#0b2136; color:#e5e7eb; padding:12px; border-radius:10px; max-height:220px; overflow:auto; font-size:12px}
/* Restore original card layout in Checkout (title, ribbon, limits, favorite) */
.method-card{height:auto !important; padding:16px !important; align-items:unset !important; justify-content:unset !important; min-height:160px}
.method-tiles{grid-template-columns:repeat(5,minmax(220px,1fr)) !important}
.method-tiles{display:grid;gap:12px}
@media (max-width: 1280px){ .method-tiles{grid-template-columns:repeat(4,minmax(0,1fr)) !important} }
@media (max-width: 1024px){ .method-tiles{grid-template-columns:repeat(3,minmax(0,1fr)) !important} }
@media (max-width: 768px){ .method-tiles{grid-template-columns:repeat(2,minmax(0,1fr)) !important} }
@media (max-width: 480px){ .method-tiles{grid-template-columns:repeat(1,minmax(0,1fr)) !important} }
.method-logo{width:220px !important; height:60px !important; object-fit:contain}
.card-ribbon{display:block !important}
.method-title-row{display:flex !important}
.method-name{display:inline !important}
.badge{display:inline-block !important}
.method-limits{display:flex !important}
.fav-btn{display:block !important}
/* */
</style>
<?php
$content = ob_get_clean();
include BASE_PATH . '/modules/checkout/layout_public.php';
?>
