<?php
/**
 * Módulo de Autenticación - Logout
 */

// Asegurar sesión iniciada y destruir sesión
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

$_SESSION = [];
session_destroy();

// Limpiar cookies de sesión
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Redirigir al login
header('Location: /index.php?module=auth&action=login');
exit;
?>