<?php
/**
 * Endpoint para obtener la lista de archivos de log
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

try {
    $logDir = __DIR__ . '/logs';
    $files = [];
    
    if (is_dir($logDir)) {
        $iterator = new DirectoryIterator($logDir);
        
        foreach ($iterator as $file) {
            if ($file->isFile() && $file->getExtension() === 'log') {
                $files[] = [
                    'name' => $file->getFilename(),
                    'size' => $file->getSize(),
                    'modified' => $file->getMTime(),
                    'modified_formatted' => date('Y-m-d H:i:s', $file->getMTime())
                ];
            }
        }
        
        // Ordenar por fecha de modificación (más reciente primero)
        usort($files, function($a, $b) {
            return $b['modified'] - $a['modified'];
        });
    }
    
    echo json_encode($files);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Error obteniendo archivos de log: ' . $e->getMessage()
    ]);
}
?>