<?php
/**
 * Script para corregir rutas de CSS en todo el proyecto
 */

// Archivos que necesitan corrección
$files_to_fix = [
    'modules/client_portal/documents.php',
    'modules/desks/index.php',
    'modules/desks/ticket.php',
    'modules/desks/create.php',
    'modules/users/index.php',
    'modules/client_portal/login.php',
    'modules/auth/login.php',
    'modules/client_portal/ticket.php',
    'modules/leads/create.php',
    'modules/desks/edit.php',
    'modules/client_portal/tickets.php',
    'modules/client_portal/layout.php',
    'modules/users/create.php',
    'modules/desks/document_review.php'
];

echo "<h1>Corrigiendo rutas de CSS</h1>";

foreach ($files_to_fix as $file) {
    $full_path = __DIR__ . '/' . $file;
    
    if (file_exists($full_path)) {
        $content = file_get_contents($full_path);
        
        // Contar niveles de directorio para determinar la ruta correcta
        $levels = substr_count($file, '/');
        $relative_path = str_repeat('../', $levels) . 'public/';
        
        // Reemplazar las rutas absolutas con rutas relativas
        $content = str_replace('href="/public/', 'href="' . $relative_path, $content);
        
        if (file_put_contents($full_path, $content)) {
            echo "✓ Corregido: $file (niveles: $levels, ruta: $relative_path)<br>";
        } else {
            echo "✗ Error al corregir: $file<br>";
        }
    } else {
        echo "✗ Archivo no encontrado: $file<br>";
    }
}

echo "<br><h2>Corrección completada</h2>";
echo "<p>Todas las rutas de CSS han sido actualizadas para usar rutas relativas.</p>";
echo "<p><a href='index.php'>Ir al sistema principal</a></p>";
?>