<?php
/**
 * Debug de usuarios para verificar credenciales
 */

require_once 'database/connection.php';

try {
    $db = getDB();
    
    echo "<h2>Usuarios en la base de datos:</h2>";
    $users = $db->select("SELECT id, username, email, first_name, last_name, status FROM users");
    
    if (empty($users)) {
        echo "<p style='color: red;'>No hay usuarios en la base de datos. Necesitas ejecutar los scripts de inicialización.</p>";
    } else {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Nombre</th><th>Estado</th></tr>";
        foreach ($users as $user) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['username']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['status']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    echo "<h2>Verificación de hash de contraseña:</h2>";
    $test_password = 'password';
    $expected_hash = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi';
    
    if (password_verify($test_password, $expected_hash)) {
        echo "<p style='color: green;'>✓ El hash de contraseña es correcto para 'password'</p>";
    } else {
        echo "<p style='color: red;'>✗ El hash de contraseña NO es correcto</p>";
    }
    
    echo "<h2>Verificación de usuario admin:</h2>";
    $admin_user = $db->selectOne(
        "SELECT id, username, email, password_hash, status FROM users WHERE username = ? OR email = ?",
        ['admin', 'admin']
    );
    
    if ($admin_user) {
        echo "<p style='color: green;'>✓ Usuario admin encontrado:</p>";
        echo "<ul>";
        echo "<li>ID: " . $admin_user['id'] . "</li>";
        echo "<li>Username: " . $admin_user['username'] . "</li>";
        echo "<li>Email: " . $admin_user['email'] . "</li>";
        echo "<li>Estado: " . $admin_user['status'] . "</li>";
        echo "</ul>";
        
        if (password_verify('password', $admin_user['password_hash'])) {
            echo "<p style='color: green;'>✓ La contraseña 'password' es correcta para admin</p>";
        } else {
            echo "<p style='color: red;'>✗ La contraseña 'password' NO es correcta para admin</p>";
        }
    } else {
        echo "<p style='color: red;'>✗ Usuario admin NO encontrado</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>