<?php
session_start();
require_once 'database/connection.php';

// Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    echo "❌ Usuario no logueado\n";
    exit;
}

echo "<h2>🔍 Debug: Actualización de Status del Lead</h2>\n";
echo "<style>body { font-family: Arial, sans-serif; margin: 20px; }</style>\n";

// 1. Verificar que el archivo view_scripts.js existe y tiene el código correcto
echo "<h3>1. Verificación del archivo JavaScript</h3>\n";
$js_file = 'modules/leads/view_scripts.js';
if (file_exists($js_file)) {
    echo "✅ Archivo view_scripts.js existe<br>\n";
    
    $js_content = file_get_contents($js_file);
    if (strpos($js_content, 'updateLeadStatus') !== false) {
        echo "✅ Función updateLeadStatus encontrada<br>\n";
    } else {
        echo "❌ Función updateLeadStatus NO encontrada<br>\n";
    }
    
    if (strpos($js_content, 'lead-status-select') !== false) {
        echo "✅ Event listener para lead-status-select encontrado<br>\n";
    } else {
        echo "❌ Event listener para lead-status-select NO encontrado<br>\n";
    }
} else {
    echo "❌ Archivo view_scripts.js NO existe<br>\n";
}

// 2. Verificar que update_status.php existe y es accesible
echo "<h3>2. Verificación del endpoint update_status.php</h3>\n";
$update_file = 'modules/leads/update_status.php';
if (file_exists($update_file)) {
    echo "✅ Archivo update_status.php existe<br>\n";
    
    // Verificar que el archivo tiene el código correcto
    $update_content = file_get_contents($update_file);
    if (strpos($update_content, 'application/json') !== false) {
        echo "✅ Respuesta JSON configurada<br>\n";
    } else {
        echo "❌ Respuesta JSON NO configurada<br>\n";
    }
} else {
    echo "❌ Archivo update_status.php NO existe<br>\n";
}

// 3. Verificar un lead específico
echo "<h3>3. Verificación de Lead de Prueba</h3>\n";
$lead_id = 10292; // Lead que sabemos que existe
try {
    $lead = $db->select("SELECT id, status, desk_id FROM leads WHERE id = ?", [$lead_id]);
    if ($lead) {
        $lead = $lead[0];
        echo "✅ Lead {$lead_id} encontrado<br>\n";
        echo "📊 Status actual: <strong>{$lead['status']}</strong><br>\n";
        echo "🏢 Desk ID: {$lead['desk_id']}<br>\n";
        
        // Verificar estados permitidos para el desk
        if ($lead['desk_id']) {
            $allowed_statuses = $db->select("SELECT status FROM desk_allowed_statuses WHERE desk_id = ?", [$lead['desk_id']]);
            if ($allowed_statuses) {
                echo "✅ Estados permitidos para el desk: " . implode(', ', array_column($allowed_statuses, 'status')) . "<br>\n";
            } else {
                echo "⚠️ No hay estados específicos para el desk, usando estados por defecto<br>\n";
            }
        }
    } else {
        echo "❌ Lead {$lead_id} NO encontrado<br>\n";
    }
} catch (Exception $e) {
    echo "❌ Error al consultar lead: " . $e->getMessage() . "<br>\n";
}

// 4. Generar HTML de prueba
echo "<h3>4. Prueba de Funcionalidad</h3>\n";
echo "<p>Aquí tienes un dropdown de prueba para verificar la funcionalidad:</p>\n";

if (isset($lead)) {
    echo "<select id='lead-status-select' class='form-select' data-lead-id='{$lead['id']}' data-original-status='{$lead['status']}'>\n";
    
    $default_statuses = ['new','contacted','qualified','demo_scheduled','demo_completed','deposit_pending','deposited','active_trader','inactive','closed_lost'];
    
    foreach($default_statuses as $status) {
        $selected = ($lead['status'] === $status) ? 'selected' : '';
        $display_name = ucfirst(str_replace('_', ' ', $status));
        echo "<option value='{$status}' {$selected}>{$display_name}</option>\n";
    }
    
    echo "</select>\n";
    echo "<div id='status-result' style='margin-top: 10px; padding: 10px; border: 1px solid #ddd; background: #f9f9f9;'></div>\n";
}

// 5. JavaScript de prueba
echo "<h3>5. JavaScript de Prueba</h3>\n";
echo "<script src='modules/leads/view_scripts.js'></script>\n";
echo "<script>\n";
echo "console.log('🔍 Debug script cargado');\n";
echo "document.addEventListener('DOMContentLoaded', function() {\n";
echo "    console.log('🔍 DOM cargado');\n";
echo "    const statusSelect = document.getElementById('lead-status-select');\n";
echo "    if (statusSelect) {\n";
echo "        console.log('✅ Status select encontrado:', statusSelect);\n";
echo "        console.log('📊 Lead ID:', statusSelect.getAttribute('data-lead-id'));\n";
echo "        console.log('📊 Status original:', statusSelect.getAttribute('data-original-status'));\n";
echo "        \n";
echo "        statusSelect.addEventListener('change', function() {\n";
echo "            console.log('🔄 Status cambiado a:', this.value);\n";
echo "            document.getElementById('status-result').innerHTML = '🔄 Cambiando status a: ' + this.value;\n";
echo "        });\n";
echo "    } else {\n";
echo "        console.error('❌ Status select NO encontrado');\n";
echo "    }\n";
echo "});\n";
echo "</script>\n";

// 6. Instrucciones
echo "<h3>6. Instrucciones de Prueba</h3>\n";
echo "<ol>\n";
echo "<li>Abre la consola del navegador (F12)</li>\n";
echo "<li>Cambia el status en el dropdown de arriba</li>\n";
echo "<li>Verifica los mensajes en la consola</li>\n";
echo "<li>Si ves errores, anótalos para solucionarlos</li>\n";
echo "</ol>\n";

echo "<h3>7. Verificación de Archivos Críticos</h3>\n";
$critical_files = [
    'modules/leads/view.php',
    'modules/leads/view_content.php',
    'modules/leads/view_scripts.js',
    'modules/leads/update_status.php'
];

foreach ($critical_files as $file) {
    if (file_exists($file)) {
        echo "✅ {$file} existe<br>\n";
    } else {
        echo "❌ {$file} NO existe<br>\n";
    }
}
?>