<?php
// Debug específico para el lead view
session_start();

// Simular sesión de usuario para debug
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['username'] = 'debug_user';
    $_SESSION['role'] = 'admin';
}

echo "<h2>🔍 Debug Lead View - ID: 10292</h2>";

// Verificar parámetros
$lead_id = 10292;
echo "<h3>1. Parámetros:</h3>";
echo "Lead ID: $lead_id<br>";
echo "Session User ID: " . ($_SESSION['user_id'] ?? 'NO SET') . "<br>";

// Verificar conexión a base de datos
echo "<h3>2. Conexión a Base de Datos:</h3>";
try {
    require_once 'database/connection.php';
    echo "✅ Conexión exitosa<br>";
    
    // Verificar si el lead existe
    $stmt = $pdo->prepare("SELECT * FROM leads WHERE id = ?");
    $stmt->execute([$lead_id]);
    $lead = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($lead) {
        echo "✅ Lead encontrado: " . $lead['first_name'] . " " . $lead['last_name'] . "<br>";
    } else {
        echo "❌ Lead NO encontrado<br>";
    }
    
} catch (Exception $e) {
    echo "❌ Error de conexión: " . $e->getMessage() . "<br>";
}

// Verificar archivos necesarios
echo "<h3>3. Archivos necesarios:</h3>";
$files_to_check = [
    'modules/leads/view.php',
    'modules/leads/view_content.php', 
    'modules/shared/layout.php'
];

foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "✅ $file existe<br>";
    } else {
        echo "❌ $file NO existe<br>";
    }
}

// Simular la carga del view
echo "<h3>4. Simulación de carga:</h3>";
try {
    $_GET['id'] = $lead_id;
    
    echo "Intentando cargar view.php...<br>";
    
    // Capturar output
    ob_start();
    include 'modules/leads/view.php';
    $output = ob_get_clean();
    
    if (empty($output)) {
        echo "❌ No se generó output<br>";
    } else {
        echo "✅ Output generado (" . strlen($output) . " caracteres)<br>";
        echo "<h4>Primeros 500 caracteres del output:</h4>";
        echo "<pre>" . htmlspecialchars(substr($output, 0, 500)) . "</pre>";
    }
    
} catch (Exception $e) {
    echo "❌ Error al cargar view: " . $e->getMessage() . "<br>";
}

echo "<h3>5. Test directo del layout:</h3>";
echo "<a href='/test/simple_crm/index.php?module=leads&action=view&id=10292' target='_blank'>🔗 Abrir lead en nueva ventana</a>";
?>