<?php
session_start();
require_once __DIR__ . '/database/connection.php';

$lead_id = $_GET['id'] ?? 1029;

echo "<h2>Debug Lead Data - ID: $lead_id</h2>";

try {
    $pdo_local = $db->getConnection();
    
    echo "<h3>1. Consulta completa con JOINs:</h3>";
    $stmt = $pdo_local->prepare(
        "SELECT l.*, 
                l.job_title AS position,
                u.username AS assigned_user,
                CONCAT(u.first_name, ' ', u.last_name) AS assigned_name,
                d.name AS desk_name,
                d.color AS desk_color
         FROM leads l
         LEFT JOIN users u ON l.assigned_to = u.id
         LEFT JOIN desks d ON l.desk_id = d.id
         WHERE l.id = ?"
    );
    $stmt->execute([$lead_id]);
    $lead_full = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($lead_full) {
        echo "<pre>";
        echo "assigned_to: " . ($lead_full['assigned_to'] ?? 'NULL') . "\n";
        echo "assigned_user: " . ($lead_full['assigned_user'] ?? 'NULL') . "\n";
        echo "assigned_name: " . ($lead_full['assigned_name'] ?? 'NULL') . "\n";
        echo "desk_id: " . ($lead_full['desk_id'] ?? 'NULL') . "\n";
        echo "desk_name: " . ($lead_full['desk_name'] ?? 'NULL') . "\n";
        echo "desk_color: " . ($lead_full['desk_color'] ?? 'NULL') . "\n";
        echo "</pre>";
    } else {
        echo "<p>No se encontró el lead con la consulta completa</p>";
    }
    
    echo "<h3>2. Consulta simple (fallback):</h3>";
    $stmt2 = $pdo_local->prepare("SELECT * FROM leads WHERE id = ? LIMIT 1");
    $stmt2->execute([$lead_id]);
    $lead_simple = $stmt2->fetch(PDO::FETCH_ASSOC);
    
    if ($lead_simple) {
        echo "<pre>";
        echo "assigned_to: " . ($lead_simple['assigned_to'] ?? 'NULL') . "\n";
        echo "desk_id: " . ($lead_simple['desk_id'] ?? 'NULL') . "\n";
        echo "</pre>";
    } else {
        echo "<p>No se encontró el lead con la consulta simple</p>";
    }
    
    echo "<h3>3. Verificar datos relacionados:</h3>";
    
    if (!empty($lead_simple['assigned_to'])) {
        $user = $db->selectOne("SELECT id, username, first_name, last_name FROM users WHERE id = ?", [$lead_simple['assigned_to']]);
        echo "<p><strong>Usuario asignado:</strong></p>";
        echo "<pre>" . print_r($user, true) . "</pre>";
    }
    
    if (!empty($lead_simple['desk_id'])) {
        $desk = $db->selectOne("SELECT id, name, color FROM desks WHERE id = ?", [$lead_simple['desk_id']]);
        echo "<p><strong>Desk asignado:</strong></p>";
        echo "<pre>" . print_r($desk, true) . "</pre>";
        
        // Verificar estados del desk
        $statuses = $db->select("SELECT status FROM desk_allowed_statuses WHERE desk_id = ? ORDER BY position ASC", [$lead_simple['desk_id']]);
        echo "<p><strong>Estados permitidos para este desk:</strong></p>";
        echo "<pre>" . print_r($statuses, true) . "</pre>";
    }
    
} catch (Exception $e) {
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
}

echo "<p><a href='/test/simple_crm/index.php?module=leads&action=view&id=$lead_id'>Ver perfil del lead</a></p>";
?>