<?php
require_once 'database/connection.php';

echo "<h2>Debug Lead 10292</h2>";

// 1. Verificar datos básicos del lead
echo "<h3>1. Datos básicos del lead 10292:</h3>";
$basic_lead = $db->select("SELECT * FROM leads WHERE id = ?", [10292]);
if ($basic_lead) {
    echo "<pre>";
    print_r($basic_lead[0]);
    echo "</pre>";
} else {
    echo "Lead 10292 no encontrado<br>";
}

// 2. Verificar la consulta completa con JOINs (la que debería usarse)
echo "<h3>2. Consulta completa con JOINs:</h3>";
$full_query = "
    SELECT l.*, 
           u.username as assigned_user, 
           CONCAT(u.first_name, ' ', u.last_name) as assigned_name,
           d.name as desk_name, 
           d.color as desk_color
    FROM leads l 
    LEFT JOIN users u ON l.assigned_to = u.id 
    LEFT JOIN desks d ON l.desk_id = d.id 
    WHERE l.id = ?
";

$full_result = $db->select($full_query, [10292]);
if ($full_result) {
    echo "<pre>";
    print_r($full_result[0]);
    echo "</pre>";
} else {
    echo "No se encontraron resultados con la consulta completa<br>";
}

// 3. Verificar si existe el usuario asignado
echo "<h3>3. Verificar usuario asignado:</h3>";
if ($basic_lead && $basic_lead[0]['assigned_to']) {
    $user = $db->select("SELECT * FROM users WHERE id = ?", [$basic_lead[0]['assigned_to']]);
    if ($user) {
        echo "Usuario encontrado:<br>";
        echo "<pre>";
        print_r($user[0]);
        echo "</pre>";
    } else {
        echo "Usuario con ID " . $basic_lead[0]['assigned_to'] . " no encontrado<br>";
    }
} else {
    echo "El lead no tiene assigned_to o es NULL<br>";
}

// 4. Verificar si existe el desk
echo "<h3>4. Verificar desk:</h3>";
if ($basic_lead && $basic_lead[0]['desk_id']) {
    $desk = $db->select("SELECT * FROM desks WHERE id = ?", [$basic_lead[0]['desk_id']]);
    if ($desk) {
        echo "Desk encontrado:<br>";
        echo "<pre>";
        print_r($desk[0]);
        echo "</pre>";
    } else {
        echo "Desk con ID " . $basic_lead[0]['desk_id'] . " no encontrado<br>";
    }
} else {
    echo "El lead no tiene desk_id o es NULL<br>";
}

// 5. Verificar qué consulta se está ejecutando realmente en view.php
echo "<h3>5. Simulando la lógica de view.php:</h3>";

try {
    $lead = $db->select($full_query, [10292]);
    if ($lead) {
        echo "Consulta principal exitosa:<br>";
        echo "<pre>";
        print_r($lead[0]);
        echo "</pre>";
    } else {
        echo "Consulta principal falló, ejecutando fallback...<br>";
        $fallback_lead = $db->select("SELECT * FROM leads WHERE id = ?", [10292]);
        if ($fallback_lead) {
            echo "Consulta fallback exitosa:<br>";
            echo "<pre>";
            print_r($fallback_lead[0]);
            echo "</pre>";
        }
    }
} catch (Exception $e) {
    echo "Error en consulta principal: " . $e->getMessage() . "<br>";
    echo "Ejecutando fallback...<br>";
    $fallback_lead = $db->select("SELECT * FROM leads WHERE id = ?", [10292]);
    if ($fallback_lead) {
        echo "Consulta fallback exitosa:<br>";
        echo "<pre>";
        print_r($fallback_lead[0]);
        echo "</pre>";
    }
}

// 6. Verificar estructura de tablas
echo "<h3>6. Estructura de tabla leads:</h3>";
$structure = $db->select("DESCRIBE leads");
echo "<pre>";
print_r($structure);
echo "</pre>";

echo "<h3>7. Estructura de tabla users:</h3>";
$structure = $db->select("DESCRIBE users");
echo "<pre>";
print_r($structure);
echo "</pre>";

echo "<h3>8. Estructura de tabla desks:</h3>";
$structure = $db->select("DESCRIBE desks");
echo "<pre>";
print_r($structure);
echo "</pre>";
?>