<?php
require_once "database/config.php";
require_once "database/connection.php";

$lead_id = 3;
echo "=== DEBUG: Verificando actividades para Lead ID: $lead_id ===\n";

try {
    $db = Database::getInstance();
    $activities = $db->select(
        "SELECT la.*, u.username AS creator_username, 
                CONCAT(u.first_name, ' ', u.last_name) AS creator_name
         FROM lead_activities la
         LEFT JOIN users u ON la.created_by = u.id
         WHERE la.lead_id = ?
         ORDER BY la.created_at DESC
         LIMIT 10",
        [$lead_id]
    );
    
    if ($activities === false) {
        echo "Error en la consulta\n";
        return;
    }
    
    echo "Número de actividades encontradas: " . count($activities) . "\n";
    echo "Contenido de \$activities:\n";
    print_r($activities);
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
